/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta;

import com.daikit.graphql.meta.GQLMetaDataModel;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLConcreteEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLInterfaceEntityMetaDataInfos;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class GQLMetaDataModelBuilder {
    public GQLMetaDataModel build(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, Collection<GQLAbstractMethodMetaData> methodMetaDatas) {
        Comparator<GQLEnumMetaData> enumComparator = new Comparator<GQLEnumMetaData>(){

            @Override
            public int compare(GQLEnumMetaData o1, GQLEnumMetaData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Comparator<GQLAbstractEntityMetaDataInfos> infosComparator = new Comparator<GQLAbstractEntityMetaDataInfos>(){

            @Override
            public int compare(GQLAbstractEntityMetaDataInfos o1, GQLAbstractEntityMetaDataInfos o2) {
                return o1.getEntity().getName().compareTo(o2.getEntity().getName());
            }
        };
        GQLMetaDataModel metaDataModel = new GQLMetaDataModel();
        metaDataModel.getEnums().addAll(enumMetaDatas);
        Collections.sort(metaDataModel.getEnums(), enumComparator);
        for (GQLEntityMetaData entityMetaData : entityMetaDatas) {
            GQLAbstractEntityMetaDataInfos infos2;
            if (entityMetaData.isConcrete()) {
                infos2 = new GQLConcreteEntityMetaDataInfos(entityMetaData);
                metaDataModel.getAllConcretes().add((GQLConcreteEntityMetaDataInfos)infos2);
                continue;
            }
            infos2 = new GQLInterfaceEntityMetaDataInfos(entityMetaData);
            metaDataModel.getAllInterfaces().add((GQLInterfaceEntityMetaDataInfos)infos2);
        }
        Collections.sort(metaDataModel.getAllConcretes(), infosComparator);
        Collections.sort(metaDataModel.getAllInterfaces(), infosComparator);
        metaDataModel.getAllEntities().forEach(infosToUpdate -> infosToUpdate.setSuperEntity(metaDataModel.getAllEntities().stream().filter(infos -> infos.getEntity().getEntityClass().equals(infosToUpdate.getEntity().getSuperEntityClass())).findFirst().orElse(null)));
        metaDataModel.getAllEntities().forEach(infos -> this.buildAndSetSuperInterfaces(metaDataModel.getAllInterfaces(), (GQLAbstractEntityMetaDataInfos)infos));
        metaDataModel.getNonEmbeddedInterfaces().forEach(infos -> this.setConcreteSubEntities(metaDataModel.getAllConcretes(), (GQLInterfaceEntityMetaDataInfos)infos));
        metaDataModel.getEmbeddedInterfaces().forEach(infos -> this.setConcreteSubEntities(metaDataModel.getAllConcretes(), (GQLInterfaceEntityMetaDataInfos)infos));
        metaDataModel.getCustomMethods().addAll(methodMetaDatas);
        return metaDataModel;
    }

    private void buildAndSetSuperInterfaces(List<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos infos) {
        this.getSuperInterfaceInfos(allInterfaces, infos).ifPresent(superInterface -> this.setSuperInterfaceInfos(allInterfaces, (GQLAbstractEntityMetaDataInfos)superInterface, infos));
    }

    private Optional<GQLInterfaceEntityMetaDataInfos> getSuperInterfaceInfos(List<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos infos) {
        return allInterfaces.stream().filter(potential -> potential.equals(infos.getSuperEntity())).findFirst();
    }

    private void setSuperInterfaceInfos(List<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos superInterfaceInfos, GQLAbstractEntityMetaDataInfos infos) {
        infos.getSuperInterfaces().add(superInterfaceInfos);
        this.getSuperInterfaceInfos(allInterfaces, superInterfaceInfos).ifPresent(superSuperInterfaceInfos -> this.setSuperInterfaceInfos(allInterfaces, (GQLAbstractEntityMetaDataInfos)superSuperInterfaceInfos, infos));
    }

    private void setConcreteSubEntities(List<GQLConcreteEntityMetaDataInfos> concretes, GQLInterfaceEntityMetaDataInfos infos) {
        infos.getConcreteSubEntities().addAll(concretes.stream().filter(concrete -> concrete.getSuperInterfaces().contains(infos)).collect(Collectors.toList()));
    }
}

