/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.utils;

import com.daikit.graphql.utils.Message;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeanUtils;

public class GQLPropertyUtils {
    public static final <T> T getPropertyValue(Object source, String propertyName) {
        Object value;
        PropertyDescriptor sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)propertyName);
        if (sourcePd == null || sourcePd.getReadMethod() == null) {
            throw new IllegalArgumentException(Message.format("No property [{}] exists on object [{}]", propertyName, source));
        }
        Method readMethod = sourcePd.getReadMethod();
        boolean reset = false;
        if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
            readMethod.setAccessible(true);
            reset = true;
        }
        try {
            value = readMethod.invoke(source, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(Message.format("Cannot read property [{}] on object [{}]", propertyName, source));
        }
        finally {
            if (reset) {
                readMethod.setAccessible(false);
            }
        }
        return (T)value;
    }

    public static final void setPropertyValue(Object target, String propertyName, Object valueToSet) {
        PropertyDescriptor targetPd = BeanUtils.getPropertyDescriptor(target.getClass(), (String)propertyName);
        if (targetPd == null || targetPd.getWriteMethod() == null) {
            throw new IllegalArgumentException(Message.format("No property [{}] exists on object [{}]", propertyName, target));
        }
        Method writeMethod = targetPd.getWriteMethod();
        boolean reset = false;
        if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
            writeMethod.setAccessible(true);
            reset = true;
        }
        try {
            writeMethod.invoke(target, valueToSet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(Message.format("Cannot write property [{}] on object [{}]", propertyName, target));
        }
        finally {
            if (reset) {
                writeMethod.setAccessible(false);
            }
        }
    }

    public static final Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        PropertyDescriptor targetPd = BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
        if (targetPd == null) {
            throw new IllegalArgumentException(Message.format("No property [{}] exists on class [{}]", propertyName, clazz));
        }
        return targetPd.getPropertyType();
    }
}

