/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Collection;
import java.util.List;

public class GQLBuilderUtils {
    public static final void addOrReplaceInputObjectFields(List<GraphQLInputObjectField> objectFields, List<GraphQLInputObjectField> objectFieldsToAdd) {
        block0: for (GraphQLInputObjectField objectField : objectFieldsToAdd) {
            for (int i = 0; i < objectFields.size(); ++i) {
                if (!objectFields.get(i).getName().equals(objectField.getName())) continue;
                objectFields.set(i, objectField);
                continue block0;
            }
            objectFields.add(objectField);
        }
    }

    public static final void addOrReplaceFieldDefinitions(List<GraphQLFieldDefinition> fieldDefinitions, Collection<GraphQLFieldDefinition> fieldDefinitionsToAdd) {
        block0: for (GraphQLFieldDefinition fieldDefinition : fieldDefinitionsToAdd) {
            for (int i = 0; i < fieldDefinitions.size(); ++i) {
                if (!fieldDefinitions.get(i).getName().equals(fieldDefinition.getName())) continue;
                fieldDefinitions.set(i, fieldDefinition);
                continue block0;
            }
            fieldDefinitions.add(fieldDefinition);
        }
    }

    public static final String typeToString(GraphQLType type) {
        StringBuilder sb = new StringBuilder();
        if (type instanceof GraphQLEnumType) {
            sb.append("Enum<").append(type.getName()).append(">");
        } else if (type instanceof GraphQLList) {
            sb.append("List<").append(GQLBuilderUtils.typeToString(((GraphQLList)type).getWrappedType())).append(">");
        } else if (type instanceof GraphQLTypeReference) {
            sb.append("Reference<").append(type.getName()).append(">");
        } else if (type instanceof GraphQLScalarType) {
            sb.append("Scalar<").append(type.getName()).append(">");
        } else {
            sb.append(type);
        }
        return sb.toString();
    }
}

