/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLBuilderUtils;
import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLAbstractTypesBuilder;
import com.daikit.graphql.datafetcher.GQLPropertyDataFetcher;
import com.daikit.graphql.meta.GQLMetaDataModel;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLInterfaceEntityMetaDataInfos;
import com.daikit.graphql.utils.Message;
import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GQLInterfaceTypesBuilder
extends GQLAbstractTypesBuilder {
    public GQLInterfaceTypesBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildInterfaceTypes(GQLMetaDataModel metaDataModel, List<GQLPropertyDataFetcher<?>> propertiesDataFetchers) {
        this.logger.debug("START building interface types...");
        for (GQLInterfaceEntityMetaDataInfos infos : metaDataModel.getNonEmbeddedInterfaces()) {
            List<GQLPropertyDataFetcher<?>> propertyDataFetchers = propertiesDataFetchers.stream().filter(propertyDataFetcher -> propertyDataFetcher.getEntityClass().isAssignableFrom(infos.getEntity().getEntityClass())).collect(Collectors.toList());
            this.getCache().getInterfaceTypes().put(infos.getEntity().getEntityClass(), this.buildInterface(infos, propertyDataFetchers));
        }
        this.logger.debug("END building interface types");
    }

    private GraphQLInterfaceType buildInterface(GQLInterfaceEntityMetaDataInfos infos, List<GQLPropertyDataFetcher<?>> interfacePropertiesDataFetchers) {
        this.logger.debug(Message.format("Build interface type [{}]", infos.getEntity().getName()));
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.name(infos.getEntity().getName());
        builder.description("Interface type for [" + infos.getEntity().getName() + "]");
        ArrayList<GraphQLFieldDefinition> fieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        GraphQLFieldDefinition idFieldDefinition = null;
        if (!infos.getEntity().isEmbedded()) {
            idFieldDefinition = this.buildIdFieldDefinition();
            fieldDefinitions.add(idFieldDefinition);
        }
        Map<GQLAbstractAttributeMetaData, GraphQLFieldDefinition> entityFieldDefinitions = this.buildEntityFieldDefinitions(infos.getEntity());
        GQLBuilderUtils.addOrReplaceFieldDefinitions(fieldDefinitions, entityFieldDefinitions.values());
        builder.fields(fieldDefinitions);
        GraphQLInterfaceType objectType = builder.build();
        if (fieldDefinitions.contains(idFieldDefinition)) {
            this.registerIdDataFetcher((GraphQLFieldsContainer)objectType, idFieldDefinition, interfacePropertiesDataFetchers);
        }
        this.registerOtherDataFetchers((GraphQLFieldsContainer)objectType, entityFieldDefinitions, interfacePropertiesDataFetchers);
        this.getCache().getCodeRegistryBuilder().typeResolver(objectType, this.buildTypeResolver(infos));
        return builder.build();
    }

    private TypeResolver buildTypeResolver(final GQLInterfaceEntityMetaDataInfos infos) {
        this.logger.debug(Message.format("Build type resolver for interface type [{}]", infos.getEntity().getName()));
        TypeResolver typeResolver = new TypeResolver(){

            public GraphQLObjectType getType(TypeResolutionEnvironment env) {
                GraphQLObjectType type = null;
                if (env.getObject() != null) {
                    GQLAbstractEntityMetaDataInfos concreteTypeInfos = infos.getConcreteSubEntities().stream().filter(infos -> infos.getEntity().getEntityClass().equals(env.getObject().getClass())).findFirst().orElse(null);
                    if (concreteTypeInfos == null) {
                        throw new IllegalArgumentException(Message.format("Not able to resolve type for object [{}] in interface [{}]", env.getObject().getClass(), infos.getEntity()));
                    }
                    type = GQLInterfaceTypesBuilder.this.getCache().getEntityType(concreteTypeInfos.getEntity().getEntityClass());
                }
                return type;
            }
        };
        return typeResolver;
    }
}

