/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.builder.types;

import com.daikit.graphql.builder.GQLSchemaBuilderCache;
import com.daikit.graphql.builder.types.GQLAbstractTypesBuilder;
import com.daikit.graphql.constants.GQLSchemaConstants;
import com.daikit.graphql.enums.GQLFilterOperatorEnum;
import com.daikit.graphql.enums.GQLScalarTypeEnum;
import com.daikit.graphql.meta.GQLMetaDataModel;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class GQLQueryFilterOperatorsInputTypeBuilder
extends GQLAbstractTypesBuilder {
    public GQLQueryFilterOperatorsInputTypeBuilder(GQLSchemaBuilderCache cache) {
        super(cache);
    }

    public void buildFilterOperatorsInputTypes(GQLMetaDataModel metaDataModel) {
        this.logger.debug("Build filter operators types");
        this.getCache().getInputScalarFilterOperators().putAll(this.buildScalarFilterOperatorsInputObjectTypes());
        metaDataModel.getEnums().forEach(enumMeta -> this.getCache().getInputEnumFilterOperators().put(enumMeta.getEnumClass(), this.buildEnumFilterOperatorsInputObjectType((GQLEnumMetaData)enumMeta)));
    }

    private Map<GQLScalarTypeEnum, GraphQLInputObjectType> buildScalarFilterOperatorsInputObjectTypes() {
        HashMap<GQLScalarTypeEnum, GraphQLInputObjectType> filterOperators = new HashMap<GQLScalarTypeEnum, GraphQLInputObjectType>();
        GraphQLEnumType numberOperatorEnumType = this.buildOperatorEnumType("numbers", GQLFilterOperatorEnum.EQUAL, GQLFilterOperatorEnum.NOT_EQUAL, GQLFilterOperatorEnum.GREATER_EQUAL, GQLFilterOperatorEnum.GREATER_THAN, GQLFilterOperatorEnum.LOWER_EQUAL, GQLFilterOperatorEnum.LOWER_THAN, GQLFilterOperatorEnum.IN, GQLFilterOperatorEnum.NOT_IN, GQLFilterOperatorEnum.NULL, GQLFilterOperatorEnum.NOT_NULL);
        GraphQLEnumType booleanOperatorEnumType = this.buildOperatorEnumType("booleans", GQLFilterOperatorEnum.EQUAL, GQLFilterOperatorEnum.NULL, GQLFilterOperatorEnum.NOT_NULL);
        GraphQLEnumType dateOperatorEnumType = this.buildOperatorEnumType("dates", GQLFilterOperatorEnum.EQUAL, GQLFilterOperatorEnum.NOT_EQUAL, GQLFilterOperatorEnum.GREATER_EQUAL, GQLFilterOperatorEnum.GREATER_THAN, GQLFilterOperatorEnum.LOWER_EQUAL, GQLFilterOperatorEnum.LOWER_THAN, GQLFilterOperatorEnum.IN, GQLFilterOperatorEnum.NOT_IN, GQLFilterOperatorEnum.NULL, GQLFilterOperatorEnum.NOT_NULL);
        GraphQLEnumType stringOperatorEnumType = this.buildOperatorEnumType("strings", GQLFilterOperatorEnum.EQUAL, GQLFilterOperatorEnum.NOT_EQUAL, GQLFilterOperatorEnum.IN, GQLFilterOperatorEnum.NOT_IN, GQLFilterOperatorEnum.NULL, GQLFilterOperatorEnum.NOT_NULL, GQLFilterOperatorEnum.EMPTY, GQLFilterOperatorEnum.NOT_EMPTY, GQLFilterOperatorEnum.STARTS_WITH, GQLFilterOperatorEnum.ENDS_WITH, GQLFilterOperatorEnum.CONTAINS, GQLFilterOperatorEnum.LIKE);
        GraphQLEnumType idOperatorEnumType = this.buildOperatorEnumType("entities", GQLFilterOperatorEnum.EQUAL, GQLFilterOperatorEnum.NOT_EQUAL, GQLFilterOperatorEnum.IN, GQLFilterOperatorEnum.NOT_IN);
        HashMap<GQLScalarTypeEnum, GraphQLEnumType> scalarOperators = new HashMap<GQLScalarTypeEnum, GraphQLEnumType>();
        scalarOperators.put(GQLScalarTypeEnum.BIG_DECIMAL, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.BIG_INTEGER, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.LONG, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.SHORT, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.FLOAT, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.INT, numberOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.ID, idOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.BOOLEAN, booleanOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.DATE, dateOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.LOCAL_DATE, dateOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.LOCAL_DATE_TIME, dateOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.CHAR, stringOperatorEnumType);
        scalarOperators.put(GQLScalarTypeEnum.STRING, stringOperatorEnumType);
        scalarOperators.entrySet().forEach(entry -> filterOperators.put((GQLScalarTypeEnum)((Object)entry.getKey()), this.buildFilterOperator((GraphQLEnumType)entry.getValue(), StringUtils.remove((String)WordUtils.capitalizeFully((String)((GQLScalarTypeEnum)((Object)((Object)entry.getKey()))).name(), (char[])new char[]{'_'}), (String)"_"), (GraphQLType)GQLSchemaConstants.SCALARS.get(entry.getKey()))));
        return filterOperators;
    }

    private GraphQLEnumType buildOperatorEnumType(String typeName, GQLFilterOperatorEnum ... operators) {
        GraphQLEnumType.Builder operatorEnumTypeBuilder = GraphQLEnumType.newEnum();
        operatorEnumTypeBuilder.name("FilterOperatorEnum" + this.removeEnumSuffix(StringUtils.capitalize((String)typeName)));
        operatorEnumTypeBuilder.description("Filter operators for " + typeName + ".");
        Arrays.asList(operators).forEach(operator -> operatorEnumTypeBuilder.value(operator.getCode(), (Object)operator, operator.getDescription()));
        return operatorEnumTypeBuilder.build();
    }

    private GraphQLInputObjectType buildEnumFilterOperatorsInputObjectType(GQLEnumMetaData enumMetaData) {
        GraphQLEnumType enumOperatorEnumType = this.buildOperatorEnumType(enumMetaData.getName(), GQLFilterOperatorEnum.EQUAL, GQLFilterOperatorEnum.NOT_EQUAL, GQLFilterOperatorEnum.IN, GQLFilterOperatorEnum.NOT_IN, GQLFilterOperatorEnum.NULL, GQLFilterOperatorEnum.NOT_NULL);
        return this.buildFilterOperator(enumOperatorEnumType, enumMetaData.getName(), (GraphQLType)this.getCache().getEnumType(enumMetaData.getEnumClass()));
    }

    private String removeEnumSuffix(String name) {
        return name.endsWith("Enum") ? name.substring(0, name.length() - 4) : name;
    }

    private GraphQLInputObjectType buildFilterOperator(GraphQLEnumType operatorType, String typeName, GraphQLType valueType) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name("FilterOperator" + typeName);
        builder.description("Filter field for value type [" + valueType.getName() + "]");
        GraphQLInputObjectField.Builder operatorFieldBuilder = GraphQLInputObjectField.newInputObjectField();
        operatorFieldBuilder.name("operator");
        operatorFieldBuilder.description("Filter operator.");
        operatorFieldBuilder.type((GraphQLInputType)new GraphQLNonNull((GraphQLType)operatorType));
        builder.field(operatorFieldBuilder.build());
        if (valueType != null) {
            GraphQLInputObjectField.Builder valueFieldBuilder = GraphQLInputObjectField.newInputObjectField();
            valueFieldBuilder.name("value");
            valueFieldBuilder.description("Filter value.");
            valueFieldBuilder.type((GraphQLInputType)new GraphQLNonNull(valueType));
            builder.field(valueFieldBuilder.build());
        }
        return builder.build();
    }
}

