/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.enums;

import java.util.HashMap;
import java.util.Map;

public enum GQLFilterOperatorEnum {
    EMPTY("isEmpty", "Field is either null or an empty text. No [value] needed for the related filter."),
    NOT_EMPTY("isNotEmpty", "Field is not null and not an empty text. No [value] needed for the related filter."),
    NULL("isNull", "Field is null. No [value] needed for the related filter."),
    NOT_NULL("isNotNull", "Field is not null. No [value] needed for the related filter."),
    ENDS_WITH("endsWith", "Field ends with text given in [value] property."),
    STARTS_WITH("startsWith", "Field starts with text given in [value] property."),
    CONTAINS("contains", "Field contains text given in [value] property."),
    LIKE("like", "Field is like text given in [value] property. Wildcard character is %."),
    EQUAL("eq", "Field equals text given in [value] property."),
    NOT_EQUAL("neq", "Field is not equal to text given in [value] property."),
    GREATER_THAN("gt", "Field is greater than number given in [value] property."),
    GREATER_EQUAL("ge", "Field is greater or equal to the number given in [value] property."),
    LOWER_THAN("lt", "Field is lower than number given in [value] property."),
    LOWER_EQUAL("le", "Field is lower or equal to the number given in [value] property."),
    IN("in", "Field is contained in list of possible values given in [value] property."),
    NOT_IN("notIn", "Field is not contained in list of possible values given in [value] property.");

    private final String code;
    private final String description;
    private static Map<String, GQLFilterOperatorEnum> MAP;

    private GQLFilterOperatorEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static GQLFilterOperatorEnum forCode(String code) {
        return MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        MAP = new HashMap<String, GQLFilterOperatorEnum>();
        for (GQLFilterOperatorEnum type : GQLFilterOperatorEnum.values()) {
            MAP.put(type.getCode(), type);
        }
    }
}

