/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.LinkedHashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Variable<T> {
    @Schema(required=true, description="Unique key by Project, can be used in the SDK / API to reference by 'key' rather than _id.")
    private String key;
    @Schema(required=true, description="Variable value can be a string, number, boolean, or JSON")
    private T value;
    @Schema(required=true, description="Variable type")
    private TypeEnum type;
    @Schema(required=true, description="Variable default value")
    private T defaultValue;
    private Boolean isDefaulted;

    private static <T> Boolean $default$isDefaulted() {
        return false;
    }

    public static <T> VariableBuilder<T> builder() {
        return new VariableBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getIsDefaulted() {
        return this.isDefaulted;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setIsDefaulted(Boolean isDefaulted) {
        this.isDefaulted = isDefaulted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDefaulted = this.getIsDefaulted();
        Boolean other$isDefaulted = other.getIsDefaulted();
        if (this$isDefaulted == null ? other$isDefaulted != null : !((Object)this$isDefaulted).equals(other$isDefaulted)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        TypeEnum this$type = this.getType();
        TypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        T this$defaultValue = this.getDefaultValue();
        T other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Variable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDefaulted = this.getIsDefaulted();
        result = result * 59 + ($isDefaulted == null ? 43 : ((Object)$isDefaulted).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        TypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        T $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public String toString() {
        return "Variable(key=" + this.getKey() + ", value=" + this.getValue() + ", type=" + (Object)((Object)this.getType()) + ", defaultValue=" + this.getDefaultValue() + ", isDefaulted=" + this.getIsDefaulted() + ")";
    }

    public Variable(String key, T value, TypeEnum type, T defaultValue, Boolean isDefaulted) {
        this.key = key;
        this.value = value;
        this.type = type;
        this.defaultValue = defaultValue;
        this.isDefaulted = isDefaulted;
    }

    public Variable() {
        this.isDefaulted = Variable.$default$isDefaulted();
    }

    public static class VariableBuilder<T> {
        private String key;
        private T value;
        private TypeEnum type;
        private T defaultValue;
        private boolean isDefaulted$set;
        private Boolean isDefaulted$value;

        VariableBuilder() {
        }

        public VariableBuilder<T> key(String key) {
            this.key = key;
            return this;
        }

        public VariableBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        public VariableBuilder<T> type(TypeEnum type) {
            this.type = type;
            return this;
        }

        public VariableBuilder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public VariableBuilder<T> isDefaulted(Boolean isDefaulted) {
            this.isDefaulted$value = isDefaulted;
            this.isDefaulted$set = true;
            return this;
        }

        public Variable<T> build() {
            Boolean isDefaulted$value = this.isDefaulted$value;
            if (!this.isDefaulted$set) {
                isDefaulted$value = Variable.$default$isDefaulted();
            }
            return new Variable<T>(this.key, this.value, this.type, this.defaultValue, isDefaulted$value);
        }

        public String toString() {
            return "Variable.VariableBuilder(key=" + this.key + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + ", defaultValue=" + this.defaultValue + ", isDefaulted$value=" + this.isDefaulted$value + ")";
        }
    }

    public static enum TypeEnum {
        STRING("String"),
        BOOLEAN("Boolean"),
        NUMBER("Number"),
        JSON("JSON");

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromClass(Class<?> clazz) {
            if (clazz == LinkedHashMap.class) {
                return JSON;
            }
            if (clazz == Boolean.class) {
                return BOOLEAN;
            }
            if (clazz == Integer.class || clazz == Double.class || clazz == Float.class) {
                return NUMBER;
            }
            if (clazz == String.class) {
                return STRING;
            }
            return null;
        }
    }
}

