/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.managers;

import com.devcycle.sdk.server.common.api.IDVCApi;
import com.devcycle.sdk.server.common.model.DVCResponse;
import com.devcycle.sdk.server.common.model.Event;
import com.devcycle.sdk.server.common.model.User;
import com.devcycle.sdk.server.local.api.DVCLocalEventsApiClient;
import com.devcycle.sdk.server.local.bucketing.LocalBucketing;
import com.devcycle.sdk.server.local.model.BucketedUserConfig;
import com.devcycle.sdk.server.local.model.DVCLocalOptions;
import com.devcycle.sdk.server.local.model.EventsBatch;
import com.devcycle.sdk.server.local.model.FlushPayload;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import retrofit2.Call;
import retrofit2.Response;

public class EventQueueManager {
    private LocalBucketing localBucketing;
    private final String sdkKey;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private IDVCApi eventsApiClient;
    private int eventFlushIntervalMS;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private boolean isFlushingEvents = false;
    private int flushEventQueueSize;
    private int maxEventQueueSize;

    public EventQueueManager(String sdkKey, LocalBucketing localBucketing, DVCLocalOptions options) throws Exception {
        this.localBucketing = localBucketing;
        this.sdkKey = sdkKey;
        this.eventFlushIntervalMS = options.getEventFlushIntervalMS();
        this.flushEventQueueSize = options.getFlushEventQueueSize();
        this.maxEventQueueSize = options.getMaxEventQueueSize();
        this.eventsApiClient = new DVCLocalEventsApiClient(sdkKey, options).initialize();
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.localBucketing.initEventQueue(sdkKey, OBJECT_MAPPER.writeValueAsString((Object)options));
        this.setupScheduler();
    }

    private void setupScheduler() {
        Runnable getConfigRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    EventQueueManager.this.flushEvents();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.scheduler.scheduleAtFixedRate(getConfigRunnable, 0L, this.eventFlushIntervalMS, TimeUnit.MILLISECONDS);
    }

    public void flushEvents() throws Exception {
        if (this.isFlushingEvents) {
            return;
        }
        if (this.sdkKey == null || this.sdkKey.equals("")) {
            throw new Exception("DevCycle is not yet initialized to publish events.");
        }
        Object[] flushPayloads = new FlushPayload[]{};
        try {
            flushPayloads = this.localBucketing.flushEventQueue(this.sdkKey);
        }
        catch (Exception e) {
            System.out.printf("DVC Error Flushing Events: %s%n", e.getMessage());
        }
        if (flushPayloads.length == 0) {
            return;
        }
        System.out.printf("AS Flush Payloads: %s%n", Arrays.toString(flushPayloads));
        int eventCount = 0;
        this.isFlushingEvents = true;
        for (Object payload : flushPayloads) {
            eventCount += ((FlushPayload)payload).eventCount;
            this.publishEvents(this.sdkKey, (FlushPayload)payload);
        }
        this.isFlushingEvents = false;
        System.out.printf("DVC Flush %d AS Events, for %d Users%n", eventCount, flushPayloads.length);
    }

    public void queueEvent(User user, Event event) throws Exception {
        if (this.checkEventQueueSize()) {
            System.out.printf("Max event queue size reached, dropping event: %s%n", event);
            return;
        }
        this.localBucketing.queueEvent(this.sdkKey, OBJECT_MAPPER.writeValueAsString((Object)user), OBJECT_MAPPER.writeValueAsString((Object)event));
    }

    public void queueAggregateEvent(Event event, BucketedUserConfig bucketedConfig) throws Exception {
        if (this.checkEventQueueSize()) {
            System.out.printf("Max event queue size reached, dropping aggregate event: %s%n", event);
            return;
        }
        if (bucketedConfig != null) {
            this.localBucketing.queueAggregateEvent(this.sdkKey, OBJECT_MAPPER.writeValueAsString((Object)event), OBJECT_MAPPER.writeValueAsString(bucketedConfig.variableVariationMap));
        } else {
            this.localBucketing.queueAggregateEvent(this.sdkKey, OBJECT_MAPPER.writeValueAsString((Object)event), "{}");
        }
    }

    private void publishEvents(final String sdkKey, final FlushPayload flushPayload) throws InterruptedException {
        Thread publishEventsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Call<DVCResponse> response = EventQueueManager.this.eventsApiClient.publishEvents(EventsBatch.builder().batch(flushPayload.records).build());
                int responseCode = EventQueueManager.this.getResponse(response);
                if (responseCode == 201) {
                    EventQueueManager.this.localBucketing.onPayloadSuccess(sdkKey, flushPayload.payloadId);
                } else {
                    System.out.printf("DVC Error Publishing Events: %d%n", responseCode);
                    EventQueueManager.this.localBucketing.onPayloadFailure(sdkKey, flushPayload.payloadId, responseCode >= 500);
                }
            }
        });
        publishEventsThread.start();
        publishEventsThread.join();
    }

    private int getResponse(Call call) {
        Response response = null;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            System.out.printf("DVC Events error: %s%n", e.getMessage());
        }
        if (response == null) {
            return 500;
        }
        return response.code();
    }

    private boolean checkEventQueueSize() throws Exception {
        int queueSize = this.localBucketing.getEventQueueSize(this.sdkKey);
        if (queueSize >= this.flushEventQueueSize) {
            if (!this.isFlushingEvents) {
                this.flushEvents();
            }
            if (queueSize >= this.maxEventQueueSize) {
                return true;
            }
        }
        return false;
    }

    public void cleanup() {
        try {
            this.flushEvents();
        }
        catch (Exception e) {
            System.out.printf("DVC Cleanup error: %s%n", e.getMessage());
        }
        this.scheduler.shutdown();
    }
}

