/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.bucketing;

import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.devcycle.sdk.server.common.model.DevCycleUser;
import com.devcycle.sdk.server.common.model.Variable;
import com.devcycle.sdk.server.local.model.BucketedUserConfig;
import com.devcycle.sdk.server.local.model.FlushPayload;
import com.devcycle.sdk.server.local.utils.ByteConversionUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.github.kawamuray.wasmtime.Engine;
import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Linker;
import io.github.kawamuray.wasmtime.Memory;
import io.github.kawamuray.wasmtime.Module;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class LocalBucketing {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final int WASM_OBJECT_ID_STRING = 1;
    private final int WASM_OBJECT_ID_UINT8ARRAY = 9;
    Store<Void> store;
    Linker linker;
    AtomicReference<Memory> memRef;
    private final Set<Integer> pinnedAddresses;
    private final HashMap<String, Integer> sdkKeyAddresses;
    private final HashMap<Variable.TypeEnum, Integer> variableTypeMap = new HashMap();
    private final Logger logger = Logger.getLogger(LocalBucketing.class.getName());

    public LocalBucketing() {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.pinnedAddresses = new HashSet<Integer>();
        this.sdkKeyAddresses = new HashMap();
        this.store = Store.withoutData();
        this.linker = new Linker(this.store.engine());
        this.memRef = new AtomicReference();
        InputStream wasmInput = this.getClass().getClassLoader().getResourceAsStream("bucketing-lib.release.wasm");
        Module module = null;
        try {
            module = Module.fromBinary((Engine)this.store.engine(), (byte[])wasmInput.readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setImportsOnLinker();
        this.linker.module(this.store, "", module);
        Memory mem = ((Extern)this.linker.get(this.store, "", "memory").get()).memory();
        this.memRef.set(mem);
        this.variableTypeMap.put(Variable.TypeEnum.BOOLEAN, 0);
        this.variableTypeMap.put(Variable.TypeEnum.NUMBER, 1);
        this.variableTypeMap.put(Variable.TypeEnum.STRING, 2);
        this.variableTypeMap.put(Variable.TypeEnum.JSON, 3);
    }

    private Collection<Extern> setImportsOnLinker() {
        Func dateNowFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.F64, () -> System.currentTimeMillis());
        this.linker.define(this.store, "env", "Date.now", Extern.fromFunc((Func)dateNowFn));
        Func consoleLogFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, addr -> {
            String message = this.readWasmString((int)addr);
            DevCycleLogger.warning("WASM error: " + message);
        });
        this.linker.define(this.store, "env", "console.log", Extern.fromFunc((Func)consoleLogFn));
        Func abortFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (messagePtr, filenamePtr, linenum, colnum) -> {
            String message = this.readWasmString((int)messagePtr);
            String fileName = this.readWasmString((int)filenamePtr);
            throw new RuntimeException("Exception in " + fileName + ":" + linenum + " : " + colnum + " " + message);
        });
        this.linker.define(this.store, "env", "abort", Extern.fromFunc((Func)abortFn));
        Func seedFn = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.F64, () -> (double)System.currentTimeMillis() * Math.random());
        this.linker.define(this.store, "env", "seed", Extern.fromFunc((Func)seedFn));
        return Arrays.asList(Extern.fromFunc((Func)dateNowFn), Extern.fromFunc((Func)consoleLogFn), Extern.fromFunc((Func)abortFn));
    }

    private int newWasmString(String param) {
        int objectIdString = 1;
        Func __newPtr = ((Extern)this.linker.get(this.store, "", "__new").get()).func();
        WasmFunctions.Function2 __new = WasmFunctions.func(this.store, (Func)__newPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        byte[] paramBytes = param.getBytes(StandardCharsets.UTF_8);
        int paramAddress = (Integer)__new.call((Object)(paramBytes.length * 2), (Object)objectIdString);
        ByteBuffer buf = this.memRef.get().buffer(this.store);
        for (int i = 0; i < paramBytes.length; ++i) {
            buf.put(paramAddress + i * 2, paramBytes[i]);
        }
        return paramAddress;
    }

    private String readWasmString(int startAddress) {
        ByteBuffer buf = this.memRef.get().buffer(this.store);
        byte[] headerBytes = new byte[]{buf.get(startAddress - 1), buf.get(startAddress - 2), buf.get(startAddress - 3), buf.get(startAddress - 4)};
        long stringLength = ByteConversionUtils.getUnsignedInt(headerBytes);
        Object result = "";
        int i = 0;
        while ((long)i < stringLength) {
            result = (String)result + (char)buf.get(startAddress + i);
            i += 2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newUint8ArrayParameter(byte[] paramData) {
        int length = paramData.length;
        Func __newPtr = ((Extern)this.linker.get(this.store, "", "__new").get()).func();
        WasmFunctions.Function2 __new = WasmFunctions.func(this.store, (Func)__newPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int headerAddr = (Integer)__new.call((Object)12, (Object)9);
        try {
            int i;
            this.pinParameter(headerAddr);
            int dataBufferAddr = (Integer)__new.call((Object)length, (Object)1);
            byte[] headerData = new byte[12];
            byte[] bufferAddrBytes = ByteConversionUtils.intToBytesLittleEndian(dataBufferAddr);
            byte[] lengthBytes = ByteConversionUtils.intToBytesLittleEndian(length << 0);
            for (int i2 = 0; i2 < 4; ++i2) {
                headerData[i2] = bufferAddrBytes[i2];
                headerData[i2 + 4] = bufferAddrBytes[i2];
                headerData[i2 + 8] = lengthBytes[i2];
            }
            ByteBuffer buf = this.memRef.get().buffer(this.store);
            for (i = 0; i < headerData.length; ++i) {
                buf.put(headerAddr + i, headerData[i]);
            }
            for (i = 0; i < length; ++i) {
                buf.put(dataBufferAddr + i, paramData[i]);
            }
        }
        finally {
            this.unpinParameter(headerAddr);
        }
        return headerAddr;
    }

    private byte[] readFromWasmMemory(int address, int length) {
        ByteBuffer buf = this.memRef.get().buffer(this.store);
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = buf.get(address + i);
        }
        return data;
    }

    private byte[] readAssemblyScriptUint8Array(int address) {
        byte[] bufferDataAddressBytes = this.readFromWasmMemory(address, 4);
        int bufferAddress = ByteConversionUtils.bytesToIntLittleEndian(bufferDataAddressBytes);
        byte[] lengthAddressBytes = this.readFromWasmMemory(address + 8, 4);
        int dataLength = ByteConversionUtils.bytesToIntLittleEndian(lengthAddressBytes);
        byte[] bufferData = this.readFromWasmMemory(bufferAddress, dataLength);
        return bufferData;
    }

    public synchronized void storeConfig(String sdkKey, String config) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int configAddress = this.newUint8ArrayParameter(config.getBytes(StandardCharsets.UTF_8));
        Func setConfigDataPtr = ((Extern)this.linker.get(this.store, "", "setConfigDataUTF8").get()).func();
        WasmFunctions.Consumer2 fn = WasmFunctions.consumer(this.store, (Func)setConfigDataPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)configAddress);
    }

    public synchronized void setPlatformData(String platformData) {
        this.unpinAll();
        int platformDataAddress = this.newUint8ArrayParameter(platformData.getBytes(StandardCharsets.UTF_8));
        Func setPlatformDataPtr = ((Extern)this.linker.get(this.store, "", "setPlatformDataUTF8").get()).func();
        WasmFunctions.Consumer1 fn = WasmFunctions.consumer(this.store, (Func)setPlatformDataPtr, (WasmValType)WasmValType.I32);
        fn.accept((Object)platformDataAddress);
    }

    public synchronized void setClientCustomData(String sdkKey, String customData) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int customDataAddress = this.newUint8ArrayParameter(customData.getBytes(StandardCharsets.UTF_8));
        Func setCustomClientDataPtr = ((Extern)this.linker.get(this.store, "", "setClientCustomDataUTF8").get()).func();
        WasmFunctions.Consumer2 fn = WasmFunctions.consumer(this.store, (Func)setCustomClientDataPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)customDataAddress);
    }

    public synchronized BucketedUserConfig generateBucketedConfig(String sdkKey, DevCycleUser user) throws JsonProcessingException {
        this.unpinAll();
        String userString = OBJECT_MAPPER.writeValueAsString((Object)user);
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int userAddress = this.newUint8ArrayParameter(userString.getBytes(StandardCharsets.UTF_8));
        Func generateBucketedConfigForUserPtr = ((Extern)this.linker.get(this.store, "", "generateBucketedConfigForUserUTF8").get()).func();
        WasmFunctions.Function2 generateBucketedConfigForUser = WasmFunctions.func(this.store, (Func)generateBucketedConfigForUserPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int resultAddress = (Integer)generateBucketedConfigForUser.call((Object)sdkKeyAddress, (Object)userAddress);
        byte[] bucketConfigBytes = this.readAssemblyScriptUint8Array(resultAddress);
        String bucketedConfigString = new String(bucketConfigBytes, StandardCharsets.UTF_8);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        BucketedUserConfig config = (BucketedUserConfig)objectMapper.readValue(bucketedConfigString, BucketedUserConfig.class);
        return config;
    }

    public synchronized byte[] getVariableForUserProtobuf(byte[] serializedParams) {
        int paramsAddr = this.newUint8ArrayParameter(serializedParams);
        Func getVariablePtr = ((Extern)this.linker.get(this.store, "", "variableForUser_PB").get()).func();
        WasmFunctions.Function1 variableForUserPB = WasmFunctions.func(this.store, (Func)getVariablePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int variableAddress = (Integer)variableForUserPB.call((Object)paramsAddr);
        byte[] varBytes = null;
        if (variableAddress > 0) {
            varBytes = this.readAssemblyScriptUint8Array(variableAddress);
        }
        return varBytes;
    }

    public synchronized void initEventQueue(String sdkKey, String options) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int optionsAddress = this.newWasmString(options);
        Func initEventQueuePtr = ((Extern)this.linker.get(this.store, "", "initEventQueue").get()).func();
        WasmFunctions.Consumer2 fn = WasmFunctions.consumer(this.store, (Func)initEventQueuePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)optionsAddress);
    }

    public synchronized void queueEvent(String sdkKey, String user, String event) {
        this.unpinAll();
        int sdkKeyAddress = this.newWasmString(sdkKey);
        int userAddress = this.getPinnedParameter(user);
        int eventAddress = this.newWasmString(event);
        Func queueEventPtr = ((Extern)this.linker.get(this.store, "", "queueEvent").get()).func();
        WasmFunctions.Consumer3 fn = WasmFunctions.consumer(this.store, (Func)queueEventPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)userAddress, (Object)eventAddress);
    }

    public synchronized void queueAggregateEvent(String sdkKey, String event, String variableVariationMap) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int eventAddress = this.getPinnedParameter(event);
        int variableVariationMapAddress = this.newWasmString(variableVariationMap);
        Func queueAggregateEventPtr = ((Extern)this.linker.get(this.store, "", "queueAggregateEvent").get()).func();
        WasmFunctions.Consumer3 fn = WasmFunctions.consumer(this.store, (Func)queueAggregateEventPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)eventAddress, (Object)variableVariationMapAddress);
    }

    public synchronized FlushPayload[] flushEventQueue(String sdkKey) throws JsonProcessingException {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        Func flushEventQueuePtr = ((Extern)this.linker.get(this.store, "", "flushEventQueue").get()).func();
        WasmFunctions.Function1 fn = WasmFunctions.func(this.store, (Func)flushEventQueuePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        int resultAddress = (Integer)fn.call((Object)sdkKeyAddress);
        String flushPayloadsStr = this.readWasmString(resultAddress);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        objectMapper.setDateFormat((DateFormat)df);
        FlushPayload[] payloads = (FlushPayload[])objectMapper.readValue(flushPayloadsStr, FlushPayload[].class);
        return payloads;
    }

    public synchronized void onPayloadFailure(String sdkKey, String payloadId, boolean retryable) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int payloadIdAddress = this.newWasmString(payloadId);
        Func onPayloadFailurePtr = ((Extern)this.linker.get(this.store, "", "onPayloadFailure").get()).func();
        WasmFunctions.Consumer3 fn = WasmFunctions.consumer(this.store, (Func)onPayloadFailurePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)payloadIdAddress, (Object)(retryable ? 1 : 0));
    }

    public synchronized void onPayloadSuccess(String sdkKey, String payloadId) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        int payloadIdAddress = this.newWasmString(payloadId);
        Func onPayloadSuccessPtr = ((Extern)this.linker.get(this.store, "", "onPayloadSuccess").get()).func();
        WasmFunctions.Consumer2 fn = WasmFunctions.consumer(this.store, (Func)onPayloadSuccessPtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        fn.accept((Object)sdkKeyAddress, (Object)payloadIdAddress);
    }

    public synchronized int getEventQueueSize(String sdkKey) {
        this.unpinAll();
        int sdkKeyAddress = this.getSDKKeyAddress(sdkKey);
        Func getEventQueueSizePtr = ((Extern)this.linker.get(this.store, "", "eventQueueSize").get()).func();
        WasmFunctions.Function1 getEventQueueSize = WasmFunctions.func(this.store, (Func)getEventQueueSizePtr, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32);
        return (Integer)getEventQueueSize.call((Object)sdkKeyAddress);
    }

    private void pinParameter(int address) {
        Func pinPtr = ((Extern)this.linker.get(this.store, "", "__pin").get()).func();
        WasmFunctions.Consumer1 pin = WasmFunctions.consumer(this.store, (Func)pinPtr, (WasmValType)WasmValType.I32);
        pin.accept((Object)address);
    }

    private void unpinParameter(int address) {
        Func unpinPtr = ((Extern)this.linker.get(this.store, "", "__unpin").get()).func();
        WasmFunctions.Consumer1 unpin = WasmFunctions.consumer(this.store, (Func)unpinPtr, (WasmValType)WasmValType.I32);
        unpin.accept((Object)address);
    }

    private void unpinAll() {
        for (int address : this.pinnedAddresses) {
            this.unpinParameter(address);
        }
        this.pinnedAddresses.clear();
    }

    private int getPinnedParameter(String param) {
        int address = this.newWasmString(param);
        this.pinParameter(address);
        this.pinnedAddresses.add(address);
        return address;
    }

    private int getSDKKeyAddress(String sdkKey) {
        if (!this.sdkKeyAddresses.containsKey(sdkKey)) {
            int sdkKeyAddress = this.newWasmString(sdkKey);
            this.pinParameter(sdkKeyAddress);
            this.sdkKeyAddresses.put(sdkKey, sdkKeyAddress);
        }
        return this.sdkKeyAddresses.get(sdkKey);
    }
}

