/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.cloud.api;

import com.devcycle.sdk.server.cloud.model.DevCycleCloudOptions;
import com.devcycle.sdk.server.common.api.APIUtils;
import com.devcycle.sdk.server.common.api.IDevCycleApi;
import com.devcycle.sdk.server.common.interceptor.AuthorizationHeaderInterceptor;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class DevCycleCloudApiClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String BUCKETING_URL = "https://bucketing-api.devcycle.com/";
    private final OkHttpClient.Builder okBuilder;
    private final Retrofit.Builder adapterBuilder;
    private String bucketingUrl;

    public DevCycleCloudApiClient(String apiKey, DevCycleCloudOptions options) {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.okBuilder = new OkHttpClient.Builder();
        APIUtils.applyRestOptions(options.getRestOptions(), this.okBuilder);
        this.okBuilder.addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(apiKey));
        this.bucketingUrl = this.isStringNullOrEmpty(options.getBaseURLOverride()) == false ? options.getBaseURLOverride() : BUCKETING_URL;
        this.bucketingUrl = this.bucketingUrl.endsWith("/") ? this.bucketingUrl : this.bucketingUrl + "/";
        this.adapterBuilder = new Retrofit.Builder().baseUrl(this.bucketingUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create());
    }

    public IDevCycleApi initialize() {
        return (IDevCycleApi)this.adapterBuilder.client(this.okBuilder.build()).build().create(IDevCycleApi.class);
    }

    private Boolean isStringNullOrEmpty(String stringToCheck) {
        return Objects.isNull(stringToCheck) || Objects.equals(stringToCheck, "");
    }
}

