/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.devcycle.sdk.server.common.exception.AfterHookError;
import com.devcycle.sdk.server.common.exception.BeforeHookError;
import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.devcycle.sdk.server.common.model.EvalHook;
import com.devcycle.sdk.server.common.model.HookContext;
import com.devcycle.sdk.server.common.model.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class EvalHooksRunner<T> {
    private List<EvalHook<T>> hooks;

    public EvalHooksRunner(List<EvalHook<T>> hooks) {
        this.hooks = hooks == null ? new ArrayList<EvalHook<T>>() : hooks;
    }

    public EvalHooksRunner() {
        this.hooks = new ArrayList<EvalHook<T>>();
    }

    public void addHook(EvalHook<T> hook) {
        if (hook != null) {
            this.hooks.add(hook);
        }
    }

    public void clearHooks() {
        this.hooks.clear();
    }

    public List<EvalHook<T>> getHooks() {
        return this.hooks;
    }

    public <T> HookContext<T> executeBefore(ArrayList<EvalHook<T>> hooks, HookContext<T> context) {
        HookContext<T> beforeContext = context;
        for (EvalHook<T> hook : hooks) {
            try {
                Optional<HookContext<T>> newContext = hook.before(beforeContext);
                if (!newContext.isPresent()) continue;
                beforeContext = beforeContext.merge(newContext.get());
            }
            catch (Exception e) {
                throw new BeforeHookError("Before hook failed", e);
            }
        }
        return beforeContext;
    }

    public void executeAfter(ArrayList<EvalHook<T>> hooks, HookContext<T> context, Variable<T> variable) {
        for (EvalHook<T> hook : hooks) {
            try {
                hook.after(context, variable);
            }
            catch (Exception e) {
                throw new AfterHookError("After hook failed", e);
            }
        }
    }

    public void executeError(ArrayList<EvalHook<T>> hooks, HookContext<T> context, Throwable error) {
        for (EvalHook<T> hook : hooks) {
            try {
                hook.error(context, error);
            }
            catch (Exception hookError) {
                DevCycleLogger.error("Error hook failed: " + hookError.getMessage(), hookError);
            }
        }
    }

    public void executeFinally(ArrayList<EvalHook<T>> hooks, HookContext<T> context, Optional<Variable<T>> variable) {
        for (EvalHook<T> hook : hooks) {
            try {
                hook.onFinally(context, variable);
            }
            catch (Exception e) {
                DevCycleLogger.error("Finally hook failed: " + e.getMessage(), e);
            }
        }
    }
}

