/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.javaplugin.merger.libextension;

import com.devonfw.cobigen.javaplugin.merger.libextension.ExtendedJavaParameter;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaGenericDeclaration;
import com.thoughtworks.qdox.model.JavaInitializer;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.Expression;
import com.thoughtworks.qdox.writer.ModelWriter;
import com.thoughtworks.qdox.writer.impl.IndentBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CustomModelWriter
implements ModelWriter {
    private IndentBuffer buffer = new IndentBuffer();

    protected final IndentBuffer getBuffer() {
        return this.buffer;
    }

    public ModelWriter writeSource(JavaSource source) {
        this.writePackage(source.getPackage());
        for (String imprt : source.getImports()) {
            this.buffer.write("import ");
            this.buffer.write(imprt);
            this.buffer.write(';');
            this.buffer.newline();
        }
        if (source.getImports().size() > 0) {
            this.buffer.newline();
        }
        ListIterator iter = source.getClasses().listIterator();
        while (iter.hasNext()) {
            JavaClass cls = (JavaClass)iter.next();
            this.writeClass(cls);
            if (!iter.hasNext()) continue;
            this.buffer.newline();
        }
        return this;
    }

    public ModelWriter writePackage(JavaPackage pckg) {
        if (pckg != null) {
            this.commentHeader((JavaAnnotatedElement)pckg);
            this.buffer.write("package ");
            this.buffer.write(pckg.getName());
            this.buffer.write(';');
            this.buffer.newline();
            this.buffer.newline();
        }
        return this;
    }

    public ModelWriter writeClass(JavaClass cls) {
        String className;
        this.commentHeader((JavaAnnotatedElement)cls);
        this.writeAccessibilityModifier(cls.getModifiers());
        this.writeNonAccessibilityModifiers(cls.getModifiers());
        this.buffer.write(cls.isEnum() ? "enum " : (cls.isInterface() ? "interface " : (cls.isAnnotation() ? "@interface " : "class ")));
        this.buffer.write(cls.getName());
        this.writeTypeParameters((JavaGenericDeclaration)cls);
        if (cls.getSuperClass() != null && !"java.lang.Object".equals(className = cls.getSuperClass().getFullyQualifiedName()) && !"java.lang.Enum".equals(className)) {
            this.buffer.write(" extends ");
            this.buffer.write(cls.getSuperClass().getGenericValue());
        }
        if (cls.getImplements().size() > 0) {
            this.buffer.write(cls.isInterface() ? " extends " : " implements ");
            ListIterator iter = cls.getImplements().listIterator();
            while (iter.hasNext()) {
                this.buffer.write(((JavaType)iter.next()).getGenericValue());
                if (!iter.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        return this.writeClassBody(cls);
    }

    private ModelWriter writeClassBody(JavaClass cls) {
        this.buffer.write(" {");
        this.buffer.newline();
        this.buffer.indent();
        if (cls.getSuperClass() != null && "java.lang.Enum".equals(cls.getSuperClass().getFullyQualifiedName())) {
            Iterator it = cls.getFields().iterator();
            while (it.hasNext()) {
                JavaField curr = (JavaField)it.next();
                this.commentHeader((JavaAnnotatedElement)curr);
                this.buffer.newline();
                this.buffer.write(curr.getName());
                if (!it.hasNext()) continue;
                this.buffer.write(", ");
            }
        } else {
            for (JavaField javaField : cls.getFields()) {
                this.buffer.newline();
                this.writeField(javaField);
            }
        }
        for (JavaConstructor javaConstructor : cls.getConstructors()) {
            this.buffer.newline();
            this.writeConstructor(javaConstructor);
        }
        for (JavaMethod javaMethod : cls.getMethods()) {
            this.buffer.newline();
            this.writeMethod(javaMethod);
        }
        for (JavaClass innerCls : cls.getNestedClasses()) {
            this.buffer.newline();
            this.writeClass(innerCls);
        }
        this.buffer.deindent();
        this.buffer.newline();
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeInitializer(JavaInitializer init) {
        if (init.isStatic()) {
            this.buffer.write("static ");
        }
        this.buffer.write('{');
        this.buffer.newline();
        this.buffer.indent();
        this.buffer.write(init.getBlockContent());
        this.buffer.deindent();
        this.buffer.newline();
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeField(JavaField field) {
        this.commentHeader((JavaAnnotatedElement)field);
        this.writeAllModifiers(field.getModifiers());
        if (!field.isEnumConstant()) {
            this.buffer.write(field.getType().getGenericValue());
            this.buffer.write(' ');
        }
        this.buffer.write(field.getName());
        if (field.isEnumConstant()) {
            if (field.getEnumConstantArguments() != null && !field.getEnumConstantArguments().isEmpty()) {
                this.buffer.write("( ");
                ListIterator iter = field.getEnumConstantArguments().listIterator();
                while (iter.hasNext()) {
                    this.buffer.write(((Expression)iter.next()).getParameterValue().toString());
                    if (!iter.hasNext()) continue;
                    this.buffer.write(", ");
                }
                this.buffer.write(" )");
            }
            if (field.getEnumConstantClass() != null) {
                this.writeClassBody(field.getEnumConstantClass());
            }
        } else if (field.getInitializationExpression() != null) {
            String fieldExpression = field.getInitializationExpression();
            fieldExpression = StringUtils.strip((String)fieldExpression, (String)"\n\r");
            if (!(fieldExpression = fieldExpression.trim()).isEmpty()) {
                this.buffer.write(" = ");
                this.buffer.write(field.getInitializationExpression());
            }
        }
        this.buffer.write(';');
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeConstructor(JavaConstructor constructor) {
        this.commentHeader((JavaAnnotatedElement)constructor);
        this.writeAllModifiers(constructor.getModifiers());
        this.buffer.write(constructor.getName());
        this.buffer.write('(');
        ListIterator iter = constructor.getParameters().listIterator();
        while (iter.hasNext()) {
            this.writeParameter((JavaParameter)iter.next());
            if (!iter.hasNext()) continue;
            this.buffer.write(", ");
        }
        this.buffer.write(')');
        if (constructor.getExceptions().size() > 0) {
            this.buffer.write(" throws ");
            Iterator excIter = constructor.getExceptions().iterator();
            while (excIter.hasNext()) {
                this.buffer.write(((JavaClass)excIter.next()).getGenericValue());
                if (!excIter.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        this.buffer.write(" {");
        this.buffer.newline();
        if (constructor.getSourceCode() != null) {
            this.buffer.write(constructor.getSourceCode());
        }
        this.buffer.write('}');
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeMethod(JavaMethod method) {
        this.commentHeader((JavaAnnotatedElement)method);
        this.writeAccessibilityModifier(method.getModifiers());
        this.writeNonAccessibilityModifiers(method.getModifiers());
        if (this.writeTypeParameters((JavaGenericDeclaration)method)) {
            this.buffer.write(' ');
        }
        this.buffer.write(method.getReturnType().getGenericValue());
        this.buffer.write(' ');
        this.buffer.write(method.getName());
        this.buffer.write('(');
        ListIterator iter = method.getParameters().listIterator();
        while (iter.hasNext()) {
            this.writeParameter((JavaParameter)iter.next());
            if (!iter.hasNext()) continue;
            this.buffer.write(", ");
        }
        this.buffer.write(')');
        if (method.getExceptions().size() > 0) {
            this.buffer.write(" throws ");
            Iterator excIter = method.getExceptions().iterator();
            while (excIter.hasNext()) {
                this.buffer.write(((JavaClass)excIter.next()).getGenericValue());
                if (!excIter.hasNext()) continue;
                this.buffer.write(", ");
            }
        }
        if (method.getSourceCode() != null && method.getSourceCode().length() > 0) {
            this.buffer.write(" {");
            this.buffer.write(method.getSourceCode());
            this.buffer.write('}');
            this.buffer.newline();
        } else {
            this.buffer.write(';');
            this.buffer.newline();
        }
        return this;
    }

    private boolean writeTypeParameters(JavaGenericDeclaration decl) {
        List typeParameters = decl.getTypeParameters();
        if (typeParameters.size() == 0) {
            return false;
        }
        this.buffer.write("<");
        boolean first = true;
        for (JavaTypeVariable v : typeParameters) {
            if (!first) {
                this.buffer.write(",");
                this.buffer.write(' ');
            } else {
                first = false;
            }
            this.buffer.write(v.getGenericValue());
        }
        this.buffer.write(">");
        return true;
    }

    private void writeNonAccessibilityModifiers(List<String> modifiers) {
        for (String modifier : modifiers) {
            if (modifier.startsWith("p")) continue;
            this.buffer.write(modifier);
            this.buffer.write(' ');
        }
    }

    private void writeAccessibilityModifier(List<String> modifiers) {
        for (String modifier : modifiers) {
            if (!modifier.startsWith("p")) continue;
            this.buffer.write(modifier);
            this.buffer.write(' ');
        }
    }

    private void writeAllModifiers(List<String> modifiers) {
        for (String modifier : modifiers) {
            this.buffer.write(modifier);
            this.buffer.write(' ');
        }
    }

    public ModelWriter writeAnnotation(JavaAnnotation annotation) {
        this.buffer.write('@');
        this.buffer.write(annotation.getType().getGenericValue());
        if (!annotation.getPropertyMap().isEmpty()) {
            this.buffer.indent();
            this.buffer.write('(');
            Set annotationEntrySet = annotation.getPropertyMap().entrySet();
            Iterator iterator = annotationEntrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (annotationEntrySet.size() != 1 || !"value".equals(entry.getKey())) {
                    this.buffer.write((String)entry.getKey());
                    this.buffer.write('=');
                }
                if (((AnnotationValue)entry.getValue()).getParameterValue() instanceof JavaAnnotation) {
                    this.writeAnnotation((JavaAnnotation)((AnnotationValue)entry.getValue()).getParameterValue());
                } else if (((AnnotationValue)entry.getValue()).getParameterValue() instanceof Collection) {
                    Collection annotations = (Collection)((AnnotationValue)entry.getValue()).getParameterValue();
                    Object[] a = annotations.toArray();
                    this.buffer.write("{");
                    for (int i = 0; i < annotations.toArray().length; ++i) {
                        if (a[i] instanceof JavaAnnotation) {
                            this.writeAnnotation((JavaAnnotation)a[i]);
                            continue;
                        }
                        if (i > 0) {
                            this.buffer.write(", " + a[i].toString());
                            continue;
                        }
                        this.buffer.write(a[i].toString());
                    }
                    this.buffer.write("}");
                } else {
                    this.buffer.write(((AnnotationValue)entry.getValue()).toString());
                }
                if (!iterator.hasNext()) continue;
                this.buffer.write(',');
                this.buffer.newline();
            }
            this.buffer.write(')');
            this.buffer.deindent();
        }
        this.buffer.newline();
        return this;
    }

    public ModelWriter writeParameter(JavaParameter parameter) {
        this.commentHeader((JavaAnnotatedElement)parameter);
        this.writeAllModifiers(((ExtendedJavaParameter)parameter).getModifiers());
        this.buffer.write(parameter.getGenericValue());
        if (parameter.isVarArgs()) {
            this.buffer.write("...");
        }
        this.buffer.write(' ');
        this.buffer.write(parameter.getName());
        return this;
    }

    protected void commentHeader(JavaAnnotatedElement entity) {
        if (entity.getComment() != null || entity.getTags().size() > 0) {
            this.buffer.write("/**");
            this.buffer.newline();
            if (entity.getComment() != null && entity.getComment().length() > 0) {
                this.buffer.write(" * ");
                this.buffer.write(entity.getComment().replaceAll("\n", "\n * "));
                this.buffer.newline();
            }
            if (entity.getTags().size() > 0) {
                if (entity.getComment() != null && entity.getComment().length() > 0) {
                    this.buffer.write(" *");
                    this.buffer.newline();
                }
                for (DocletTag docletTag : entity.getTags()) {
                    this.buffer.write(" * @");
                    this.buffer.write(docletTag.getName());
                    if (docletTag.getValue().length() > 0) {
                        this.buffer.write(' ');
                        this.buffer.write(docletTag.getValue());
                    }
                    this.buffer.newline();
                }
            }
            this.buffer.write(" */");
            this.buffer.newline();
        }
        if (entity.getAnnotations() != null) {
            for (JavaAnnotation annotation : entity.getAnnotations()) {
                this.writeAnnotation(annotation);
            }
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

