/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.FeatureUser;
import com.flagsmith.FlagsAndTraits;
import com.flagsmith.FlagsmithAPIWrapper;
import com.flagsmith.FlagsmithCache;
import com.flagsmith.FlagsmithCacheConfig;
import com.flagsmith.FlagsmithSDK;
import com.flagsmith.Trait;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class FlagsmithCachedAPIWrapper
implements FlagsmithSDK {
    private final FlagsmithAPIWrapper flagsmithAPIWrapper;
    private final FlagsmithCacheConfig.FlagsmithInternalCache cache;

    public FlagsmithCachedAPIWrapper(FlagsmithCacheConfig.FlagsmithInternalCache cache, FlagsmithAPIWrapper flagsmithAPIWrapper) {
        this.cache = cache;
        this.flagsmithAPIWrapper = flagsmithAPIWrapper;
    }

    @Override
    public FlagsAndTraits getFeatureFlags(FeatureUser user, boolean doThrow) {
        String cacheKey = this.cache.getEnvFlagsCacheKey();
        if (user == null && StringUtils.isBlank((CharSequence)cacheKey)) {
            return this.flagsmithAPIWrapper.getFeatureFlags(null, doThrow);
        }
        if (user != null) {
            this.assertValidUser(user);
            return (FlagsAndTraits)this.cache.getCache().get((Object)user.getIdentifier(), k -> this.flagsmithAPIWrapper.getFeatureFlags(user, doThrow));
        }
        return (FlagsAndTraits)this.cache.getCache().get((Object)cacheKey, k -> this.flagsmithAPIWrapper.getFeatureFlags(user, doThrow));
    }

    @Override
    public FlagsAndTraits getUserFlagsAndTraits(FeatureUser user, boolean doThrow) {
        this.assertValidUser(user);
        return (FlagsAndTraits)this.cache.getCache().get((Object)user.getIdentifier(), k -> this.flagsmithAPIWrapper.getUserFlagsAndTraits(user, doThrow));
    }

    @Override
    public Trait postUserTraits(FeatureUser user, Trait toUpdate, boolean doThrow) {
        this.assertValidUser(user);
        FlagsAndTraits flagsAndTraits = this.getCachedFlagsIfTraitsMatch(user, Arrays.asList(toUpdate));
        if (flagsAndTraits != null) {
            this.flagsmithAPIWrapper.getLogger().info("User trait unchanged for user {}, trait: {}", user.getIdentifier(), toUpdate);
            return toUpdate;
        }
        return this.flagsmithAPIWrapper.postUserTraits(user, toUpdate, doThrow);
    }

    @Override
    public FlagsAndTraits identifyUserWithTraits(FeatureUser user, List<Trait> traits, boolean doThrow) {
        this.assertValidUser(user);
        FlagsAndTraits flagsAndTraits = this.getCachedFlagsIfTraitsMatch(user, traits);
        if (flagsAndTraits != null) {
            return flagsAndTraits;
        }
        flagsAndTraits = this.flagsmithAPIWrapper.identifyUserWithTraits(user, traits, doThrow);
        this.cache.getCache().put((Object)user.getIdentifier(), (Object)flagsAndTraits);
        return flagsAndTraits;
    }

    @Override
    public FlagsmithCache getCache() {
        return this.cache;
    }

    private FlagsAndTraits getCachedFlagsIfTraitsMatch(FeatureUser user, List<Trait> traitsToMatch) {
        FlagsAndTraits flagsAndTraits = (FlagsAndTraits)this.cache.getCache().getIfPresent((Object)user.getIdentifier());
        if (flagsAndTraits == null) {
            return null;
        }
        if (flagsAndTraits.getTraits() != null) {
            boolean allTraitsFound;
            boolean bl = allTraitsFound = traitsToMatch == null || traitsToMatch.isEmpty() || traitsToMatch.stream().allMatch(t -> {
                Trait newTrait = new Trait(null, t.getKey(), t.getValue());
                return flagsAndTraits.getTraits().contains(newTrait);
            });
            if (allTraitsFound) {
                return flagsAndTraits;
            }
        }
        this.cache.getCache().invalidate((Object)user.getIdentifier());
        return null;
    }
}

