/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FlyAccessException;
import com.zink.fly.Notifiable;
import com.zink.fly.stub.NotifyMessageDispatcher;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Remoter {
    private OutputStream os = null;
    private InputStream is = null;
    private DataInputStream dis = null;
    private BlockingQueue<Long> replyQueue = new LinkedBlockingQueue<Long>(1);
    private boolean messagePending = false;
    private NotifyMessageDispatcher notifyDispatcher;

    public Remoter(String string, int n) {
        try {
            this.initStreams(new Socket(string, n));
            new MessageListener().start();
        }
        catch (Exception exception) {
            throw new FlyAccessException("Failed connection to Fly on " + string + ":" + n, exception);
        }
    }

    public Remoter(InetAddress inetAddress, int n) {
        try {
            this.initStreams(new Socket(inetAddress, n));
            new MessageListener().start();
        }
        catch (Exception exception) {
            throw new FlyAccessException("Failed connection to Fly on " + inetAddress.getHostName() + ":" + n, exception);
        }
    }

    private void initStreams(Socket socket) throws IOException {
        this.os = socket.getOutputStream();
        this.is = socket.getInputStream();
        this.dis = new DataInputStream(this.is);
    }

    public synchronized void setNotifyMessageDispatcher(NotifyMessageDispatcher notifyMessageDispatcher) {
        if (this.notifyDispatcher == null) {
            this.notifyDispatcher = notifyMessageDispatcher;
        }
    }

    public DataInputStream getDataInputStream() {
        return this.dis;
    }

    public long sendOperation(byte[] byArray) {
        long l = 0L;
        try {
            this.os.write(byArray);
            l = this.replyQueue.take();
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        return l;
    }

    public synchronized void setMessagePending() {
        this.messagePending = true;
    }

    public synchronized void setMessageComplete() {
        this.messagePending = false;
    }

    void addNotifyDetails(long l, Notifiable notifiable, Class clazz) {
        this.notifyDispatcher.registerHandler(l, notifiable, clazz);
    }

    class MessageListener
    extends Thread {
        public MessageListener() {
            this.setName("MessageListener");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Remoter.this.messagePending = false;
            while (!this.isInterrupted()) {
                try {
                    while (Remoter.this.messagePending) {
                        Thread.yield();
                    }
                    long l = Remoter.this.dis.readLong();
                    if (l == -1L || l == -2L) {
                        Remoter.this.notifyDispatcher.decodeAndQueue(l, Remoter.this.dis);
                        continue;
                    }
                    Remoter.this.setMessagePending();
                    Remoter.this.replyQueue.put(l);
                }
                catch (Exception exception) {
                    throw new FlyAccessException(exception);
                }
            }
        }
    }
}

