/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FieldCodec;
import com.zink.fly.FlyAccessException;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ObjectCodec {
    FieldCodec fieldCodec = null;

    public ObjectCodec(FieldCodec fieldCodec) {
        this.fieldCodec = fieldCodec;
    }

    public final void writeObject(DataOutputStream dataOutputStream, Object object) {
        try {
            if (object != null) {
                byte[] byArray = this.fieldCodec.writeField(object);
                dataOutputStream.writeLong(byArray.length);
                dataOutputStream.write(byArray);
            } else {
                dataOutputStream.writeLong(0L);
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
    }

    public final Object readObject(DataInputStream dataInputStream) {
        Object object = null;
        try {
            long l = dataInputStream.readLong();
            if (l == 0L) {
                return object;
            }
            byte[] byArray = new byte[(int)l];
            dataInputStream.readFully(byArray);
            object = this.fieldCodec.readField(byArray);
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        return object;
    }
}

