/*
 * Decompiled with CFR 0.152.
 */
package com.github.bpazy.sender;

import com.github.bpazy.util.Encoder;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqSender {
    private static final Logger logger = LoggerFactory.getLogger(CqSender.class);
    private static final CqSender INSTANCE = new CqSender();
    private static final Joiner blankJoiner = Joiner.on((String)" ").skipNulls();
    private DatagramSocket server;

    public CqSender() {
        try {
            this.server = new DatagramSocket();
        }
        catch (SocketException e) {
            logger.error("\u9352\u6fc6\ue750\u9356\u6707qSender\u6fb6\u8fab\u89e6", (Throwable)e);
        }
    }

    public static CqSender getDefaultSender() {
        return INSTANCE;
    }

    private DatagramPacket buildMsgPacket(String flag, String msg) {
        try {
            byte[] send = (flag + " " + new String(Encoder.encode(msg), "UTF8")).getBytes("UTF8");
            return new DatagramPacket(send, send.length, InetAddress.getByName("127.0.0.1"), 11235);
        }
        catch (UnsupportedEncodingException | UnknownHostException e) {
            logger.error("Encode error or Host name error", (Throwable)e);
            throw new Error("Encode error or Host name error");
        }
    }

    private void sendMsgPacket(String flag, String msg) throws IOException {
        DatagramPacket packet = this.buildMsgPacket(flag, msg);
        this.server.send(packet);
    }

    private void sendCmdPacket(String ... args) throws IOException {
        DatagramPacket packet = this.buildCmdPacket(args);
        this.server.send(packet);
    }

    private DatagramPacket buildCmdPacket(String ... args) {
        try {
            byte[] sentBytes = blankJoiner.join((Object[])args).getBytes("UTF8");
            return new DatagramPacket(sentBytes, sentBytes.length, InetAddress.getByName("127.0.0.1"), 11235);
        }
        catch (UnsupportedEncodingException | UnknownHostException e) {
            logger.error("Encode error or Host name error", (Throwable)e);
            throw new Error("Encode error or Host name error");
        }
    }

    public void sendPrivateMsg(String qq, String msg) throws IOException {
        this.sendMsgPacket("PrivateMessage " + qq, msg);
    }

    public void sendGroupMsg(String groupMsg, String msg) throws IOException {
        this.sendMsgPacket("GroupMessage " + groupMsg, msg);
    }

    public void sendDiscussMsg(String discussID, String msg) throws IOException {
        this.sendMsgPacket("DiscussMessage " + discussID, msg);
    }

    public void sendGroupBan(String groupID, String qq, long duration) throws IOException {
        this.sendCmdPacket("GroupBan", groupID, qq, duration + "");
    }
}

