/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.plt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CostTrend
extends ApplicationFrame {
    public CostTrend(List<Double> costTrend, String title) {
        super(title);
        JFreeChart lineChart = ChartFactory.createLineChart((String)title, (String)"Generation", (String)"Costs", (CategoryDataset)this.createDataset(costTrend), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartPanel chartPanel = new ChartPanel(lineChart);
        chartPanel.setPreferredSize(new Dimension(560, 367));
        this.setContentPane((Container)chartPanel);
        this.pack();
    }

    private DefaultCategoryDataset createDataset(List<Double> costTrend) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < costTrend.size(); ++i) {
            dataset.addValue((Number)costTrend.get(i), (Comparable)((Object)"cost"), (Comparable)((Object)("" + i)));
        }
        return dataset;
    }

    public void showIt() {
        this.setVisible(true);
    }

    public void showIt(boolean centered) {
        if (centered) {
            RefineryUtilities.centerFrameOnScreen((Window)((Object)this));
        }
        this.showIt();
    }

    public static void main(String[] args) {
        List<Double> costTrends = Arrays.asList(1.0, 1.2, 1.3, 1.34, 1.23, 1.11, 1.5);
        CostTrend chart = new CostTrend(costTrends, "cost vs generation");
        RefineryUtilities.centerFrameOnScreen((Window)((Object)chart));
        chart.showIt(true);
    }
}

