/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.spm.apriori;

import com.github.chen0040.spm.AbstractSequentialAssocRuleMiner;
import com.github.chen0040.spm.data.ItemSetWithTimeId;
import com.github.chen0040.spm.data.Sequence;
import com.github.chen0040.spm.data.Sequences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSP
extends AbstractSequentialAssocRuleMiner {
    private static final Logger logger = LoggerFactory.getLogger(GSP.class);

    @Override
    public Sequences minePatterns(Iterable<? extends Sequence> database, List<String> uniqueItems, long maxTimeWindow) {
        HashMap<String, Integer> frequency = new HashMap<String, Integer>();
        for (Sequence sequence : database) {
            for (String item : uniqueItems) {
                if (!sequence.containsItem(item)) continue;
                frequency.put(item, frequency.getOrDefault(item, 0) + 1);
            }
        }
        List seeds = frequency.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= this.getMinSupportLevel()).map(entry -> {
            String item = (String)entry.getKey();
            int itemCount = (Integer)entry.getValue();
            Sequence sequence = new Sequence();
            ItemSetWithTimeId itemSet = new ItemSetWithTimeId();
            itemSet.addItem(item);
            itemSet.setSupport(itemCount);
            sequence.addElement(itemSet);
            return sequence;
        }).collect(Collectors.toList());
        Sequences sequences = new Sequences();
        int k = 1;
        while (!seeds.isEmpty()) {
            ArrayList candidates = new ArrayList();
            for (int i = 0; i < seeds.size(); ++i) {
                Sequence s1 = (Sequence)seeds.get(i);
                for (int j = 0; j < seeds.size(); ++j) {
                    if (i == j) continue;
                    Sequence s2 = (Sequence)seeds.get(j);
                    if (k == 1) {
                        candidates.addAll(this.level2Join(s1, s2));
                        continue;
                    }
                    if (!this.canJoin(s1, s2)) continue;
                    candidates.addAll(this.join(s1, s2));
                }
            }
            int candidateCount = candidates.size();
            for (int i = candidateCount - 1; i >= 0; --i) {
                int support = 0;
                Sequence candidate = (Sequence)candidates.get(i);
                if (candidate.countItems() != k + 1) {
                    candidates.remove(i);
                    continue;
                }
                for (Sequence sequence : database) {
                    if (!sequence.contains(candidate, maxTimeWindow)) continue;
                    ++support;
                }
                candidate.setSupport(support);
                if (support >= this.getMinSupportLevel()) {
                    sequences.add(candidate);
                    continue;
                }
                candidates.remove(i);
            }
            seeds = candidates;
            ++k;
        }
        return sequences;
    }

    private boolean canJoin(Sequence s1, Sequence s2) {
        Sequence s1Prime = s1.dropFirstItem();
        Sequence s2Prime = s2.dropLastItem();
        return s1Prime.equals(s2Prime);
    }

    private List<Sequence> join(Sequence s1, Sequence s2) {
        Sequence s1p = s1.append(s2.lastItem(), s2.isLastItemSeparateElement());
        return Collections.singletonList(s1p);
    }

    private List<Sequence> level2Join(Sequence s1, Sequence s2) {
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        Sequence s1p = s1.append(s2.lastItem(), true);
        Sequence s2p = s1.append(s2.lastItem(), false);
        result.add(s1p);
        result.add(s2p);
        return result;
    }
}

