/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.spm.data;

import com.github.chen0040.spm.data.ItemSet;
import com.github.chen0040.spm.utils.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ItemSets
implements Serializable {
    private static final long serialVersionUID = 41666260104933710L;
    private List<ItemSet> sets = new ArrayList<ItemSet>();

    public ItemSets addAll(List<ItemSet> fis) {
        this.sets.addAll(fis);
        return this;
    }

    public List<ItemSet> getSets() {
        return this.sets;
    }

    public void setSets(List<ItemSet> sets) {
        this.sets = sets;
    }

    public Stream<ItemSet> stream() {
        return this.sets.stream();
    }

    public int countSets() {
        return this.sets.size();
    }

    public ItemSet getItemSet(int i) {
        return this.sets.get(i);
    }

    public ItemSet removeItemSetAt(int i) {
        return this.sets.remove(i);
    }

    public Set<String> generateCombinations() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.countSets(); ++i) {
            ItemSet itemSet = this.getItemSet(i);
            List<String> items = itemSet.getItems();
            List<List<String>> combinations = CollectionUtils.generateCombinations(items);
            for (List<String> combination : combinations) {
                combination.sort(String::compareTo);
                result.add(combination.stream().collect(Collectors.joining(", ")));
            }
        }
        return result;
    }

    public boolean isSubsetOf(ItemSets rhs) {
        Set<String> allsets = this.generateCombinations();
        Set<String> rhssets = rhs.generateCombinations();
        for (String item : allsets) {
            if (rhssets.contains(item)) continue;
            return false;
        }
        return true;
    }

    public String getSignature() {
        List items = this.generateCombinations().stream().collect(Collectors.toList());
        items.sort(String::compareTo);
        return "(" + items.stream().collect(Collectors.joining(")\r\n(")) + ")";
    }
}

