/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.HttpServerExchange;
import httpserver.util.Encoding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class FormData {
    private final Map<String, String> fields;

    public static FormData parseForm(HttpServerExchange httpServerExchange, Charset charset) throws IOException {
        String string = httpServerExchange.getRequestHeader("Content-Type");
        if ("application/x-www-form-urlencoded".equals(string)) {
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : stringArray = new String(httpServerExchange.getInputStream().readAllBytes(), charset).split("&")) {
                int n = string2.indexOf(61);
                if (n == -1) {
                    hashMap.put(string2, "");
                    continue;
                }
                String string3 = Encoding.decodeUrl(string2.substring(0, n));
                String string4 = Encoding.decodeUrl(string2.substring(n + 1));
                hashMap.put(string3, string4);
            }
            return new FormData(hashMap);
        }
        if ("multipart/form-data".equals(string)) {
            throw new IOException("Multipart form parsing not supported");
        }
        throw new IOException("Request body contains unknown form type: " + string);
    }

    private FormData(Map<String, String> map) {
        this.fields = map;
    }

    public String get(String string) {
        return this.fields.get(string);
    }
}

