/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.MultipartForm;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class FormPart {
    private static final byte[] CRLF_CRLF = "\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    private static final int LENGTH_CONTENT_TYPE = "Content-Type: ".length();
    private static final int LENGTH_CONTENT_DISPOSITION = "Content-Disposition: ".length();
    private String disposition;
    private String type;
    private final List<String> headers;
    private final byte[] data;
    private final int start;
    private final int middle;
    private final int end;

    public FormPart(byte[] byArray, int n, int n2) throws IOException {
        this.middle = MultipartForm.indexOf(byArray, CRLF_CRLF, n, n2);
        if (this.middle == -1) {
            throw new IOException("Malformed form, no CRLFCRLF between boundaries");
        }
        this.headers = new ArrayList<String>();
        String string = new String(byArray, n, this.middle - n);
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.isEmpty()) continue;
                this.headers.add(string2);
                if (string2.startsWith("Content-Type: ")) {
                    this.type = string2.substring(LENGTH_CONTENT_TYPE);
                }
                if (!string2.startsWith("Content-Disposition: ")) continue;
                this.disposition = string2.substring(LENGTH_CONTENT_DISPOSITION);
            }
        }
        this.data = byArray;
        this.start = n;
        this.end = n2;
    }

    public String getContentType() {
        return this.type;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public byte[] getFormPartData() {
        byte[] byArray = new byte[this.end - this.start];
        System.arraycopy(this.data, this.start, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.end - this.middle];
        System.arraycopy(this.data, this.middle, byArray, 0, byArray.length);
        return byArray;
    }
}

