/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionType;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.UnaryExpression;

public final class BinaryExpression
extends UnaryExpression {
    private final Expression _operator;
    private final Expression _second;

    BinaryExpression(int expressionType, Class<?> resultType, Expression operator, Expression first, Expression second) {
        super(expressionType, resultType, first);
        if (expressionType == 6 && operator == null) {
            throw new IllegalArgumentException(new NullPointerException("operator"));
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        this._operator = operator;
        this._second = second;
    }

    public Expression getOperator() {
        return this._operator;
    }

    public Expression getSecond() {
        return this._second;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._second == null ? 0 : this._second.hashCode());
        result = 31 * result + (this._operator == null ? 0 : this._operator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)obj;
        if (this._second == null ? other._second != null : !this._second.equals(other._second)) {
            return false;
        }
        return !(this._operator == null ? other._operator != null : !this._operator.equals(other._operator));
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        if (this.getOperator() != null) {
            b.append(this.getOperator().toString());
            b.append(' ');
            b.append(ExpressionType.toString(this.getExpressionType()));
            b.append(' ');
            b.append(this.getFirst().toString());
            b.append(' ');
            b.append(':');
        } else {
            b.append(this.getFirst().toString());
            b.append(' ');
            b.append(ExpressionType.toString(this.getExpressionType()));
        }
        b.append(' ');
        b.append(this.getSecond().toString());
        b.append(')');
        return b.toString();
    }
}

