/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.annotations.ForeignKeyObject;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BaseMapper<T extends BaseEntity> {
    private Class<T> clazz;

    public BaseMapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Optional<T> map(ResultSet set) throws SQLException {
        BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
        try (ResultSet resultSet = set;){
            if (!set.next()) {
                Optional optional = Optional.empty();
                return optional;
            }
            this.setFields(set, entity);
            Optional<BaseEntity> optional = Optional.of(entity);
            return optional;
        }
    }

    public List<T> mapToList(ResultSet set) throws SQLException {
        ArrayList<BaseEntity> list = new ArrayList<BaseEntity>();
        try (ResultSet resultSet = set;){
            while (set.next()) {
                BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
                this.setFields(set, entity);
                list.add(entity);
            }
        }
        return list;
    }

    private <E extends BaseEntity> void setFields(ResultSet set, E entity) throws SQLException {
        List<Field> fields = Utilities.getEntityFields(entity.getClass(), true);
        String tableName = Utilities.getTableName(entity.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                if (field.getAnnotation(ForeignKeyObject.class) != null) {
                    if (!BaseEntity.class.isAssignableFrom(field.getType())) {
                        throw new IllegalArgumentException(String.format("Type %s which is annotated as a foreign key, does not extend BaseEntity", field.getType().getSimpleName()));
                    }
                    BaseEntity foreignKeyObject = (BaseEntity)IoC.resolve(field.getType());
                    this.setFields(set, foreignKeyObject);
                    field.set(entity, foreignKeyObject);
                    continue;
                }
                Object value = set.getObject(tableName + "_" + field.getName(), field.getType());
                field.set(entity, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

