/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.exceptions.ConnectionFailedException;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.mysql.cj.exceptions.CJCommunicationsException;
import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnection
implements Closeable {
    public static String HOST;
    public static String DATABASE;
    public static String USERNAME;
    public static String PASSWORD;
    public static int PORT;
    public static boolean LOG_QUERIES;
    private Connection connection;
    private boolean isConnectionValid;

    public DBConnection() {
        try {
            String connectionString = "jdbc:mysql://" + HOST + ":" + PORT + "/" + DATABASE + "?serverTimezone=UTC";
            Class.forName("com.mysql.cj.jdbc.Driver");
            DriverManager.setLoginTimeout(5);
            this.connection = DriverManager.getConnection(connectionString, USERNAME, PASSWORD);
            this.isConnectionValid = true;
        }
        catch (CJCommunicationsException | CommunicationsException e) {
            this.isConnectionValid = false;
            throw new ConnectionFailedException();
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            this.isConnectionValid = false;
        }
    }

    public boolean isValid() {
        return this.isConnectionValid;
    }

    public ResultSet execute(String query) throws SQLException {
        Statement statement = this.connection.createStatement();
        Utilities.log(query);
        ResultSet set = statement.executeQuery(query);
        statement.closeOnCompletion();
        return set;
    }

    public ResultSet execute(String query, Object ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query);
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
        Utilities.log(query);
        ResultSet set = statement.executeQuery();
        statement.closeOnCompletion();
        return set;
    }

    public long update(String query) throws SQLException {
        Statement statement = this.connection.createStatement();
        Utilities.log(query);
        statement.executeUpdate(query, 1);
        statement.closeOnCompletion();
        ResultSet set = statement.getGeneratedKeys();
        if (set.next()) {
            return set.getLong(1);
        }
        return -1L;
    }

    public long update(String query, Object ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query, 1);
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
        Utilities.log(query);
        statement.executeUpdate();
        statement.closeOnCompletion();
        ResultSet set = statement.getGeneratedKeys();
        if (set.next()) {
            return set.getLong(1);
        }
        return -1L;
    }

    public boolean isOpen() {
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException e) {
            System.err.println("Could not determine connection status");
            this.isConnectionValid = false;
            return false;
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            System.err.println("Could not close database connection");
            e.printStackTrace();
        }
        finally {
            this.isConnectionValid = false;
        }
    }

    static {
        PORT = 3306;
        LOG_QUERIES = true;
    }
}

