/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.paging;

import com.github.collinalpert.java2db.caching.CachingModule;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.paging.PaginationResult;
import com.github.collinalpert.java2db.queries.Query;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;

public class CacheablePaginationResult<T extends BaseEntity>
extends PaginationResult<T> {
    private final Duration cacheExpiration;
    private final CachingModule<List<T>> listCache;
    private final CachingModule<Stream<T>> streamCache;

    public CacheablePaginationResult(List<Query<T>> queries, Duration cacheExpiration) {
        super(queries);
        this.cacheExpiration = cacheExpiration;
        this.listCache = new CachingModule();
        this.streamCache = new CachingModule();
    }

    @Override
    public List<T> getPage(int number) {
        return this.listCache.getOrAdd(Integer.toString(number), () -> super.getPage(number), this.cacheExpiration);
    }

    @Override
    public Stream<T> getPageAsStream(int number) {
        return this.streamCache.getOrAdd(Integer.toString(number), () -> super.getPageAsStream(number), this.cacheExpiration);
    }

    public void invalidateCaches() {
        this.listCache.invalidate();
        this.streamCache.invalidate();
    }

    public void invalidateCache(String name) {
        this.listCache.invalidate(name);
        this.streamCache.invalidate(name);
    }
}

