/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.pagination;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.Query;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import java.util.List;
import java.util.stream.Stream;

public class PaginationResult<T extends BaseEntity> {
    protected final List<Query<T>> queries;
    private SqlFunction<T, ?> orderFunction;
    private OrderTypes orderType;

    public PaginationResult(List<Query<T>> queries) {
        this.queries = queries;
    }

    public int getNumberOfPages() {
        return this.queries.size();
    }

    private void pageNumberCheck(int pageNumber) {
        if (pageNumber > this.queries.size()) {
            throw new IllegalArgumentException("The requested page number exceeds the total number of pages.");
        }
        if (pageNumber == 0) {
            throw new IllegalArgumentException("The first page starts at the index 1.");
        }
    }

    public List<T> getPage(int number) {
        this.pageNumberCheck(number);
        return this.queries.get(number - 1).orderBy(this.orderFunction, this.orderType).toList();
    }

    public Stream<T> getPageAsStream(int number) {
        this.pageNumberCheck(number);
        return this.queries.get(number - 1).orderBy(this.orderFunction, this.orderType).toStream();
    }

    public PaginationResult<T> orderBy(SqlFunction<T, ?> orderFunction) {
        return this.orderBy(orderFunction, OrderTypes.ASCENDING);
    }

    public PaginationResult<T> orderBy(SqlFunction<T, ?> orderFunction, OrderTypes orderType) {
        this.orderFunction = orderFunction;
        this.orderType = orderType;
        return this;
    }
}

