/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.utilities;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.Mapper;
import com.github.collinalpert.java2db.services.BaseService;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class IoC {
    private static Map<Class<? extends BaseEntity>, BaseService<? extends BaseEntity>> services = new HashMap<Class<? extends BaseEntity>, BaseService<? extends BaseEntity>>();
    private static Map<Class<? extends BaseEntity>, Mapper<? extends BaseEntity>> mappers = new HashMap<Class<? extends BaseEntity>, Mapper<? extends BaseEntity>>();

    public static <E> E createInstance(Class<E> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("Class %s could not be instantiated.", clazz.getSimpleName()));
        }
    }

    public static <S extends BaseService> S resolveService(Class<S> clazz) {
        Optional<BaseService> service = services.values().stream().filter(x -> x.getClass().equals(clazz)).findFirst();
        if (!service.isPresent()) {
            throw new IllegalArgumentException(String.format("An instance of the service %s has not been registered yet. Please use the \"registerService\" method.", clazz.getSimpleName()));
        }
        return (S)((BaseService)clazz.cast(service.get()));
    }

    public static <E extends BaseEntity> Mapper<E> resolveMapper(Class<E> clazz) {
        if (!mappers.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("An instance of a mapper for the entity %s has not been registered yet. Please use the \"registerMapper\" method.", clazz.getSimpleName()));
        }
        return mappers.get(clazz);
    }

    public static <E extends BaseEntity> Mapper<E> resolveMapperOrElse(Class<E> clazz, Mapper<E> defaultMapper) {
        if (mappers.containsKey(clazz)) {
            return mappers.get(clazz);
        }
        return defaultMapper;
    }

    public static <E extends BaseEntity, S extends BaseService<E>> S resolveServiceByEntity(Class<E> clazz) {
        if (!services.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("An instance of a service for the entity %s has not been registered yet. Please use the \"registerService\" method.", clazz.getSimpleName()));
        }
        return (S)services.get(clazz);
    }

    public static <E extends BaseEntity, S extends BaseService<E>> void registerService(Class<E> clazz, S service) {
        services.put(clazz, service);
    }

    public static <E extends BaseEntity, M extends Mapper<E>> void registerMapper(Class<E> clazz, M mapper) {
        mappers.put(clazz, mapper);
    }

    public static <E extends BaseEntity> boolean isServiceRegistered(Class<E> clazz) {
        return services.containsKey(clazz);
    }

    public static <E extends BaseEntity> boolean isMapperRegistered(Class<E> clazz) {
        return mappers.containsKey(clazz);
    }
}

