/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;

public class TableColumnReference {
    private final String tableName;
    private final Field column;
    private final String alias;
    private final String referenceColumn;

    public TableColumnReference(String tableName, Field column, String alias, String referenceColumn) {
        this.tableName = tableName;
        this.column = column;
        this.alias = alias;
        this.referenceColumn = referenceColumn;
    }

    public Field getColumn() {
        return this.column;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getReference() {
        return this.referenceColumn.isEmpty() ? this.tableName : this.referenceColumn;
    }

    public String getSQLNotation() {
        return String.format("`%s`.`%s`", this.getIdentifier(), Utilities.getColumnName(this.column));
    }

    public String getAliasNotation() {
        return this.getIdentifier() + "_" + Utilities.getColumnName(this.column);
    }

    public boolean isForeignKey() {
        return this.column.getAnnotation(ForeignKeyEntity.class) != null;
    }

    public String getIdentifier() {
        return this.alias.isEmpty() ? this.tableName : this.alias;
    }

    public String toString() {
        return this.getSQLNotation();
    }
}

