/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.modules;

import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.annotations.Ignore;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.utilities.UniqueIdentifier;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class FieldModule {
    private static final TableModule tableModule = new TableModule();

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass) {
        return this.getEntityFields(instanceClass, null, false);
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, boolean includeForeignKeys) {
        return this.getEntityFields(instanceClass, null, includeForeignKeys);
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, Class<?> delimiter) {
        return this.getEntityFields(instanceClass, delimiter, false);
    }

    private <T extends BaseEntity> List<Field> getEntityFields(Class<? super T> instanceClass, Class<?> delimiter, boolean includeForeignKeys) {
        LinkedList<Field> fields = new LinkedList<Field>();
        do {
            fields.addAll(Arrays.stream(instanceClass.getDeclaredFields()).filter(field -> field.getAnnotation(Ignore.class) == null && (includeForeignKeys || field.getAnnotation(ForeignKeyEntity.class) == null)).collect(Collectors.toList()));
        } while ((instanceClass = instanceClass.getSuperclass()) != delimiter);
        return fields;
    }

    public List<TableColumnReference> getAllFields(Class<? extends BaseEntity> instanceClass) {
        return this.getAllFields(instanceClass, "");
    }

    public List<TableColumnReference> getAllFields(Class<? extends BaseEntity> instanceClass, String alias) {
        LinkedList<TableColumnReference> fields = new LinkedList<TableColumnReference>();
        for (Field field : this.getEntityFields(instanceClass, true)) {
            if (field.getType().isEnum()) continue;
            if (field.getAnnotation(ForeignKeyEntity.class) != null) {
                String tempAlias = UniqueIdentifier.generate(tableModule.getTableName(field.getType()).substring(0, 1), field.getName());
                fields.add(new TableColumnReference(tableModule.getTableName(instanceClass), field, tempAlias, alias));
                fields.addAll(this.getAllFields(field.getType(), tempAlias));
                continue;
            }
            fields.add(new TableColumnReference(tableModule.getTableName(instanceClass), field, alias, ""));
        }
        return fields;
    }
}

