/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.ForeignKeyReference;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.FieldModule;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.queries.EntityProjectionQuery;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.QueryConstraints;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import com.trigersoft.jaque.expression.LambdaExpression;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;

public class EntityQuery<E extends BaseEntity>
implements Queryable<E> {
    private static final TableModule tableModule = new TableModule();
    private final Class<E> type;
    private final Mappable<E> mapper;
    private SqlPredicate<E> whereClause;
    private SqlFunction<E, ?>[] orderByClause;
    private OrderTypes orderType;
    private Integer limit;
    private int limitOffset;

    public EntityQuery(Class<E> type, Mappable<E> mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public EntityQuery<E> where(SqlPredicate<E> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.and(predicate);
        return this;
    }

    public EntityQuery<E> orWhere(SqlPredicate<E> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.or(predicate);
        return this;
    }

    @SafeVarargs
    public final EntityQuery<E> orderBy(SqlFunction<E, ?> ... functions) {
        return this.orderBy(OrderTypes.ASCENDING, functions);
    }

    @SafeVarargs
    public final EntityQuery<E> orderBy(OrderTypes type, SqlFunction<E, ?> ... functions) {
        this.orderByClause = functions;
        this.orderType = type;
        return this;
    }

    public EntityQuery<E> limit(int limit, int offset) {
        this.limit = limit;
        this.limitOffset = offset;
        return this;
    }

    public EntityQuery<E> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public <R> Queryable<R> project(SqlFunction<E, R> projection) {
        LambdaExpression<SqlFunction<E, R>> lambda = LambdaExpression.parse(projection);
        Class<?> returnType = lambda.getBody().getResultType();
        return new EntityProjectionQuery(returnType, projection, this);
    }

    @Override
    public Optional<E> getFirst() {
        DBConnection connection = new DBConnection();
        try {
            Optional<E> optional = this.mapper.map(connection.execute(this.getQuery()));
            connection.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
    }

    @Override
    public List<E> toList() {
        DBConnection connection = new DBConnection();
        try {
            List<E> list = this.mapper.mapToList(connection.execute(this.getQuery()));
            connection.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    @Override
    public Stream<E> toStream() {
        DBConnection connection = new DBConnection();
        try {
            Stream<E> stream = this.mapper.mapToStream(connection.execute(this.getQuery()));
            connection.close();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        }
    }

    @Override
    public E[] toArray() {
        DBConnection connection = new DBConnection();
        try {
            BaseEntity[] baseEntityArray = this.mapper.mapToArray(connection.execute(this.getQuery()));
            connection.close();
            return baseEntityArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return (BaseEntity[])Array.newInstance(this.type, 0);
            }
        }
    }

    @Override
    public String getQuery() {
        StringBuilder builder = new StringBuilder("select ");
        LinkedList<String> fieldList = new LinkedList<String>();
        LinkedList<ForeignKeyReference> foreignKeyList = new LinkedList<ForeignKeyReference>();
        String tableName = tableModule.getTableName(this.type);
        FieldModule fieldModule = new FieldModule();
        List<TableColumnReference> columns = fieldModule.getAllFields(this.type);
        for (TableColumnReference column : columns) {
            if (column.isForeignKey()) {
                foreignKeyList.add(new ForeignKeyReference(column.getReference(), column.getColumn().getAnnotation(ForeignKeyEntity.class).value(), tableModule.getTableName(column.getColumn().getType()), column.getAlias()));
                continue;
            }
            fieldList.add(String.format("%s as %s", column.getSQLNotation(), column.getAliasNotation()));
        }
        builder.append(String.join((CharSequence)", ", fieldList)).append(" from `").append(tableName).append("`");
        for (ForeignKeyReference foreignKey : foreignKeyList) {
            builder.append(" left join `").append(foreignKey.getChildTable()).append("` ").append(foreignKey.getAlias()).append(" on `").append(foreignKey.getParentClass()).append("`.`").append(foreignKey.getParentForeignKey()).append("` = `").append(foreignKey.getAlias()).append("`.`id`");
        }
        builder.append(this.generateQueryClauses(tableName));
        return builder.toString();
    }

    public String generateQueryClauses(String tableName) {
        StringBuilder builder = new StringBuilder();
        SqlPredicate<E> constraints = QueryConstraints.getConstraints(this.type);
        SqlPredicate<E> clauseCopy = this.whereClause;
        clauseCopy = clauseCopy == null ? constraints : clauseCopy.and(constraints);
        builder.append(" where ").append(Lambda2Sql.toSql(clauseCopy, tableName));
        if (this.orderByClause != null && this.orderByClause.length > 0) {
            builder.append(" order by ");
            if (this.orderByClause.length == 1) {
                builder.append(Lambda2Sql.toSql(this.orderByClause[0], tableName));
            } else {
                StringJoiner joiner = new StringJoiner(", ", "coalesce(", ")");
                for (SqlFunction<E, ?> orderByFunction : this.orderByClause) {
                    joiner.add(Lambda2Sql.toSql(orderByFunction, tableName));
                }
                builder.append(joiner.toString());
            }
            builder.append(" ").append(this.orderType.getSql());
        }
        if (this.limit != null) {
            builder.append(" limit ").append(this.limitOffset).append(", ").append(this.limit);
        }
        return builder.toString();
    }

    public String getTableName() {
        return tableModule.getTableName(this.type);
    }
}

