/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface Queryable<T> {
    public Optional<T> getFirst();

    public List<T> toList();

    public Stream<T> toStream();

    public T[] toArray();

    default public CompletableFuture<Optional<T>> getFirstAsync() {
        return CompletableFuture.supplyAsync(this::getFirst);
    }

    default public CompletableFuture<Void> getFirstAsync(Consumer<? super Optional<T>> callback) {
        return this.getFirstAsync().thenAcceptAsync(callback);
    }

    default public CompletableFuture<List<T>> toListAsync() {
        return CompletableFuture.supplyAsync(this::toList);
    }

    default public CompletableFuture<Void> toListAsync(Consumer<? super List<T>> callback) {
        return this.toListAsync().thenAcceptAsync(callback);
    }

    default public CompletableFuture<Stream<T>> toStreamAsync() {
        return CompletableFuture.supplyAsync(this::toStream);
    }

    default public CompletableFuture<Void> toStreamAsync(Consumer<? super Stream<T>> callback) {
        return this.toStreamAsync().thenAcceptAsync(callback);
    }

    default public CompletableFuture<T[]> toArrayAsync() {
        return CompletableFuture.supplyAsync(this::toArray);
    }

    default public CompletableFuture<Void> toArrayAsync(Consumer<? super T[]> callback) {
        return this.toArrayAsync().thenAcceptAsync(callback);
    }

    public String getQuery();
}

