/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.services;

import com.github.collinalpert.java2db.annotations.DefaultIfNull;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.exceptions.IllegalEntityFieldAccessException;
import com.github.collinalpert.java2db.mappers.BaseMapper;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.AnnotationModule;
import com.github.collinalpert.java2db.modules.FieldModule;
import com.github.collinalpert.java2db.modules.LoggingModule;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.pagination.CacheablePaginationResult;
import com.github.collinalpert.java2db.pagination.PaginationResult;
import com.github.collinalpert.java2db.queries.EntityQuery;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class BaseService<T extends BaseEntity> {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final AnnotationModule annotationModule = new AnnotationModule();
    private static final FieldModule fieldModule = new FieldModule();
    private static final TableModule tableModule = new TableModule();
    private static final LoggingModule loggingModule = new LoggingModule();
    protected final Class<T> type = this.getGenericType();
    protected final String tableName;
    protected final Mappable<T> mapper = IoC.resolveMapper(this.type, new BaseMapper<T>(this.type));
    private final String idAccess;

    protected BaseService() {
        this.tableName = tableModule.getTableName(this.type);
        SqlFunction idFunc = BaseEntity::getId;
        this.idAccess = Lambda2Sql.toSql(idFunc, this.tableName);
    }

    public long create(T instance) throws SQLException {
        StringBuilder insertQuery = this.createInsertHeader();
        StringJoiner joiner = new StringJoiner(", ", "(", ");");
        fieldModule.getEntityFields(instance.getClass(), BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            if (this.getFieldValue((Field)field, instance) == null && annotationModule.hasAnnotation((Field)field, DefaultIfNull.class, DefaultIfNull::onCreate)) {
                joiner.add("default");
                return;
            }
            joiner.add(this.getSqlValue((Field)field, instance));
        });
        joiner.add("default");
        insertQuery.append(joiner.toString());
        try (DBConnection connection = new DBConnection();){
            long id = connection.update(insertQuery.toString());
            loggingModule.logf("%s successfully created!", this.type.getSimpleName());
            long l = id;
            return l;
        }
    }

    public void create(T ... instances) throws SQLException {
        this.create(Arrays.asList(instances));
    }

    public void create(List<T> instances) throws SQLException {
        if (instances.isEmpty()) {
            return;
        }
        StringBuilder insertQuery = this.createInsertHeader();
        CharSequence[] rows = new String[instances.size()];
        int instancesSize = instances.size();
        for (int i = 0; i < instancesSize; ++i) {
            List<Field> entityFields = fieldModule.getEntityFields(((BaseEntity)instances.get(i)).getClass(), BaseEntity.class);
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (Field entityField : entityFields) {
                entityField.setAccessible(true);
                BaseEntity instance = (BaseEntity)instances.get(i);
                if (this.getFieldValue(entityField, instance) == null && annotationModule.hasAnnotation(entityField, DefaultIfNull.class, DefaultIfNull::onCreate)) {
                    joiner.add("default");
                    return;
                }
                joiner.add(this.getSqlValue(entityField, instance));
            }
            joiner.add("default");
            rows[i] = joiner.toString();
        }
        insertQuery.append(String.join((CharSequence)", ", rows));
        try (DBConnection connection = new DBConnection();){
            connection.update(insertQuery.toString());
            loggingModule.logf("%s entities were successfully created.", this.type.getSimpleName());
        }
    }

    public long count() {
        return this.count(x -> true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long count(SqlPredicate<T> predicate) {
        try (DBConnection connection = new DBConnection();){
            long l;
            block17: {
                ResultSet result;
                block15: {
                    long l2;
                    block16: {
                        result = connection.execute(String.format("select count(%s) from `%s` where %s;", this.idAccess, this.tableName, Lambda2Sql.toSql(predicate, this.tableName)));
                        try {
                            if (!result.next()) break block15;
                            l2 = result.getLong(String.format("count(%s)", this.idAccess));
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                l = 0L;
                if (result == null) break block17;
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("Could not get amount of rows in table %s for this predicate.", this.tableName));
        }
    }

    public boolean any() {
        return this.any(x -> true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean any(SqlPredicate<T> predicate) {
        try (DBConnection connection = new DBConnection();){
            boolean bl;
            block17: {
                ResultSet result;
                block15: {
                    boolean bl2;
                    block16: {
                        result = connection.execute(String.format("select exists(select %s from `%s` where %s limit 1) as result;", this.idAccess, this.tableName, Lambda2Sql.toSql(predicate, this.tableName)));
                        try {
                            if (!result.next()) break block15;
                            boolean bl3 = bl2 = result.getInt("result") == 1;
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return bl2;
                }
                bl = false;
                if (result == null) break block17;
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("Could not check if a row matches this condition on table %s.", this.tableName));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean hasDuplicates(SqlFunction<T, ?> column) {
        String sqlColumn = Lambda2Sql.toSql(column, this.tableName);
        try (DBConnection connection = new DBConnection();){
            boolean bl;
            block13: {
                ResultSet result = connection.execute(String.format("select %s from `%s` group by %s having count(%s) > 1", sqlColumn, this.tableName, sqlColumn, sqlColumn));
                try {
                    bl = result.next();
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("Could not check if duplicate values exist in column %s on table %s.", sqlColumn, this.tableName));
        }
    }

    protected EntityQuery<T> createQuery() {
        return new EntityQuery<T>(this.type, this.mapper);
    }

    public Optional<T> getSingle(SqlPredicate<T> predicate) {
        return this.createQuery().where(predicate).getFirst();
    }

    public EntityQuery<T> getMultiple(SqlPredicate<T> predicate) {
        return this.createQuery().where(predicate);
    }

    public Optional<T> getById(long id) {
        return this.getSingle(x -> x.getId() == id);
    }

    public List<T> getAll() {
        return this.createQuery().toList();
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy) {
        return this.createQuery().orderBy(orderBy).toList();
    }

    public List<T> getAll(SqlFunction<T, ?> ... orderBy) {
        return this.createQuery().orderBy(orderBy).toList();
    }

    public List<T> getAll(OrderTypes sortingType, SqlFunction<T, ?> orderBy) {
        return this.createQuery().orderBy(sortingType, orderBy).toList();
    }

    public List<T> getAll(OrderTypes sortingType, SqlFunction<T, ?> ... orderBy) {
        return this.createQuery().orderBy(sortingType, orderBy).toList();
    }

    public PaginationResult<T> createPagination(int entriesPerPage) {
        return new PaginationResult<T>(this.createPaginationQueries(entriesPerPage));
    }

    public PaginationResult<T> createPagination(SqlPredicate<T> predicate, int entriesPerPage) {
        return new PaginationResult<T>(this.createPaginationQueries(predicate, entriesPerPage));
    }

    public CacheablePaginationResult<T> createPagination(int entriesPerPage, Duration cacheExpiration) {
        return new CacheablePaginationResult<T>(this.createPaginationQueries(entriesPerPage), cacheExpiration);
    }

    public CacheablePaginationResult<T> createPagination(SqlPredicate<T> predicate, int entriesPerPage, Duration cacheExpiration) {
        return new CacheablePaginationResult<T>(this.createPaginationQueries(predicate, entriesPerPage), cacheExpiration);
    }

    public void update(T instance) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(this.updateQuery(instance));
            loggingModule.logf("%s with id %d was successfully updated.", this.type.getSimpleName(), ((BaseEntity)instance).getId());
        }
    }

    public void update(T ... instances) throws SQLException {
        this.update(Arrays.asList(instances));
    }

    public void update(List<T> instances) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            for (BaseEntity instance : instances) {
                connection.update(this.updateQuery(instance));
            }
            loggingModule.logf("%s were successfully updated.", this.type.getSimpleName());
        }
    }

    private String updateQuery(T instance) {
        StringBuilder updateQuery = new StringBuilder("update `").append(this.tableName).append("` set ");
        StringJoiner fieldJoiner = new StringJoiner(", ");
        fieldModule.getEntityFields(instance.getClass(), BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            String sqlValue = this.getFieldValue((Field)field, instance) == null && annotationModule.hasAnnotation((Field)field, DefaultIfNull.class, DefaultIfNull::onUpdate) ? "default" : this.getSqlValue((Field)field, instance);
            fieldJoiner.add(String.format("`%s` = %s", tableModule.getColumnName((Field)field), sqlValue));
        });
        return updateQuery.append(fieldJoiner.toString()).append(String.format(" where %s = ", this.idAccess)).append(((BaseEntity)instance).getId()).toString();
    }

    public <R> void update(long entityId, SqlFunction<T, R> column, R newValue) throws SQLException {
        this.update(x -> x.getId() == entityId, column, newValue);
    }

    public <R> void update(SqlPredicate<T> condition, SqlFunction<T, R> column, R newValue) throws SQLException {
        String query = String.format("update `%s` set %s = %s where %s;", this.tableName, Lambda2Sql.toSql(column, this.tableName), this.convertToSql(newValue), Lambda2Sql.toSql(condition, this.tableName));
        try (DBConnection connection = new DBConnection();){
            connection.update(query);
            loggingModule.logf("Column-specific update for table '%s' was successful.", tableModule.getTableName(this.type));
        }
    }

    public void delete(T instance) throws SQLException {
        long id = ((BaseEntity)instance).getId();
        this.delete(x -> x.getId() == id);
    }

    public void delete(long id) throws SQLException {
        this.delete(x -> x.getId() == id);
    }

    public void delete(List<T> entities) throws SQLException {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (BaseEntity entity : entities) {
            joiner.add(Long.toString(entity.getId()));
        }
        String joinedIds = joiner.toString();
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("delete from `%s` where %s in %s", this.tableName, this.idAccess, joinedIds));
            loggingModule.logf("%s with ids %s successfully deleted!", this.type.getSimpleName(), joinedIds);
        }
    }

    public void delete(T ... entities) throws SQLException {
        this.delete(Arrays.asList(entities));
    }

    public void delete(long ... ids) throws SQLException {
        ArrayList<Long> list = new ArrayList<Long>(ids.length);
        for (long id : ids) {
            list.add(id);
        }
        this.delete(x -> list.contains(x.getId()));
    }

    public void delete(SqlPredicate<T> predicate) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("delete from `%s` where %s;", this.tableName, Lambda2Sql.toSql(predicate, this.tableName)));
            loggingModule.logf("%s successfully deleted!", this.type.getSimpleName());
        }
    }

    public void truncateTable() throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("truncate table `%s`;", this.tableName));
            loggingModule.logf("Table %s was successfully truncated.", this.tableName);
        }
    }

    private Class<T> getGenericType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private StringBuilder createInsertHeader() {
        return new StringBuilder("insert into `").append(this.tableName).append("` ").append(fieldModule.getEntityFields(this.type).stream().map(field -> String.format("`%s`", tableModule.getColumnName((Field)field))).collect(Collectors.joining(", ", "(", ")"))).append(" values ");
    }

    private Object getFieldValue(Field entityField, T entityInstance) {
        try {
            return entityField.get(entityInstance);
        }
        catch (IllegalAccessException e) {
            throw new IllegalEntityFieldAccessException(entityField.getName(), this.type.getSimpleName(), e.getMessage());
        }
    }

    private String getSqlValue(Field entityField, T entityInstance) {
        return this.convertToSql(this.getFieldValue(entityField, entityInstance));
    }

    private String convertToSql(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Boolean) {
            boolean bool = (Boolean)value;
            return bool ? "1" : "0";
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)value;
            return "'" + DATE_TIME_FORMATTER.format(dateTime) + "'";
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return "'" + DATE_FORMATTER.format(date) + "'";
        }
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return "'" + TIME_FORMATTER.format(time) + "'";
        }
        return value.toString();
    }

    private List<EntityQuery<T>> createPaginationQueries(int entriesPerPage) {
        return this.createPaginationQueries(x -> true, entriesPerPage);
    }

    private List<EntityQuery<T>> createPaginationQueries(SqlPredicate<T> predicate, int entriesPerPage) {
        long count = this.count(predicate);
        double numberOfPages = Math.ceil((double)count / (double)entriesPerPage);
        ArrayList<EntityQuery<T>> queries = new ArrayList<EntityQuery<T>>((int)numberOfPages);
        int i = 0;
        while ((double)i < numberOfPages) {
            int offset = i * entriesPerPage;
            queries.add(this.getMultiple(predicate).limit(entriesPerPage, offset));
            ++i;
        }
        return queries;
    }
}

