/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.services;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.async.AsyncEntityQuery;
import com.github.collinalpert.java2db.queries.async.AsyncSingleEntityQuery;
import com.github.collinalpert.java2db.services.BaseService;
import com.github.collinalpert.java2db.utilities.FunctionUtils;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AsyncBaseService<T extends BaseEntity>
extends BaseService<T> {
    public CompletableFuture<Void> createAsync(T instance) {
        return this.createAsync(instance, FunctionUtils.empty());
    }

    public CompletableFuture<Void> createAsync(T instance, Consumer<? super Long> callback) {
        return this.createAsync(instance, callback, null);
    }

    public CompletableFuture<Void> createAsync(T instance, Consumer<? super Long> callback, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.supplyAsync(Utilities.supplierHandling(() -> super.create(instance), exceptionHandling)).thenAcceptAsync(callback);
    }

    public CompletableFuture<Void> createAsync(T ... instances) {
        return this.createAsync(Arrays.asList(instances), (Consumer<SQLException>)null);
    }

    public CompletableFuture<Void> createAsync(Consumer<SQLException> exceptionHandling, T ... instances) {
        return this.createAsync(Arrays.asList(instances), exceptionHandling);
    }

    public CompletableFuture<Void> createAsync(List<T> instances) {
        return this.createAsync(instances, (Consumer<SQLException>)null);
    }

    public CompletableFuture<Void> createAsync(List<T> instances, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.create(instances), exceptionHandling));
    }

    public CompletableFuture<Void> countAsync(Consumer<? super Long> callback) {
        return CompletableFuture.supplyAsync(() -> super.count()).thenAcceptAsync(callback);
    }

    public CompletableFuture<Void> countAsync(SqlPredicate<T> predicate, Consumer<? super Long> callback) {
        return CompletableFuture.supplyAsync(() -> super.count(predicate)).thenAcceptAsync(callback);
    }

    public CompletableFuture<Void> anyAsync(Consumer<? super Boolean> callback) {
        return CompletableFuture.supplyAsync(() -> super.any()).thenAcceptAsync(callback);
    }

    public CompletableFuture<Void> anyAsync(SqlPredicate<T> predicate, Consumer<? super Boolean> callback) {
        return CompletableFuture.supplyAsync(() -> super.any(predicate)).thenAcceptAsync(callback);
    }

    public CompletableFuture<Void> hasDuplicatesAsync(SqlFunction<T, ?> column, Consumer<? super Boolean> callback) {
        return CompletableFuture.supplyAsync(() -> super.hasDuplicates(column)).thenAcceptAsync(callback);
    }

    protected AsyncEntityQuery<T> createAsyncQuery() {
        return new AsyncEntityQuery(this.type);
    }

    protected AsyncSingleEntityQuery<T> createAsyncSingleQuery() {
        return new AsyncSingleEntityQuery(this.type);
    }

    public CompletableFuture<Void> getFirstAsync(SqlPredicate<T> predicate, Consumer<? super Optional<T>> callback) {
        return CompletableFuture.supplyAsync(() -> super.getFirst(predicate)).thenAcceptAsync(callback);
    }

    @Override
    public AsyncSingleEntityQuery<T> getSingle(SqlPredicate<T> predicate) {
        return this.createAsyncSingleQuery().where((SqlPredicate)predicate);
    }

    @Override
    public AsyncEntityQuery<T> getMultiple(SqlPredicate<T> predicate) {
        return this.createAsyncQuery().where((SqlPredicate)predicate);
    }

    public CompletableFuture<Void> getByIdAsync(long id, Consumer<? super Optional<T>> callback) {
        return this.getSingle(x -> x.getId() == id).firstAsync(callback);
    }

    public CompletableFuture<Void> getAllAsync(Consumer<? super List<T>> callback) {
        return this.createAsyncQuery().toListAsync(callback);
    }

    public CompletableFuture<Void> getAllAsync(Consumer<? super List<T>> callback, SqlFunction<T, ?> orderBy) {
        return this.createAsyncQuery().orderBy((SqlFunction)orderBy).toListAsync(callback);
    }

    public CompletableFuture<Void> getAllAsync(Consumer<? super List<T>> callback, SqlFunction<T, ?> ... orderBy) {
        return this.getAllAsync(callback, OrderTypes.ASCENDING, orderBy);
    }

    public CompletableFuture<Void> getAllAsync(Consumer<? super List<T>> callback, OrderTypes sortingType, SqlFunction<T, ?> orderBy) {
        return this.createAsyncQuery().orderBy(sortingType, (SqlFunction)orderBy).toListAsync(callback);
    }

    public CompletableFuture<Void> getAllAsync(Consumer<? super List<T>> callback, OrderTypes sortingType, SqlFunction<T, ?> ... orderBy) {
        return this.createAsyncQuery().orderBy(sortingType, orderBy).toListAsync(callback);
    }

    public CompletableFuture<Void> updateAsync(T instance) {
        return this.updateAsync(instance, null);
    }

    public CompletableFuture<Void> updateAsync(T instance, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.update(instance), exceptionHandling));
    }

    public CompletableFuture<Void> updateAsync(T ... instances) {
        return this.updateAsync(Arrays.asList(instances), (Consumer<SQLException>)null);
    }

    public CompletableFuture<Void> updateAsync(Consumer<SQLException> exceptionHandling, T ... instances) {
        return this.updateAsync(Arrays.asList(instances), exceptionHandling);
    }

    public CompletableFuture<Void> updateAsync(List<T> instances) {
        return this.updateAsync(instances, (Consumer<SQLException>)null);
    }

    public CompletableFuture<Void> updateAsync(List<T> instances, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.update(instances), exceptionHandling));
    }

    public <R> CompletableFuture<Void> updateAsync(long entityId, SqlFunction<T, R> column, R newValue) {
        return this.updateAsync(x -> x.getId() == entityId, column, newValue, null);
    }

    public <R> CompletableFuture<Void> updateAsync(long entityId, SqlFunction<T, R> column, R newValue, Consumer<SQLException> exceptionHandling) {
        return this.updateAsync(x -> x.getId() == entityId, column, newValue, exceptionHandling);
    }

    public <R> CompletableFuture<Void> updateAsync(SqlPredicate<T> condition, SqlFunction<T, R> column, R newValue) {
        return this.updateAsync(condition, column, newValue, null);
    }

    public <R> CompletableFuture<Void> updateAsync(SqlPredicate<T> condition, SqlFunction<T, R> column, R newValue, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.update(condition, column, newValue), exceptionHandling));
    }

    public CompletableFuture<Void> deleteAsync(T instance) {
        return this.deleteAsync(instance, null);
    }

    public CompletableFuture<Void> deleteAsync(T instance, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.delete(instance), exceptionHandling));
    }

    public CompletableFuture<Void> deleteAsync(long id) {
        return this.deleteAsync(id, (Consumer<SQLException>)null);
    }

    public CompletableFuture<Void> deleteAsync(long id, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.delete(id), exceptionHandling));
    }

    public CompletableFuture<Void> deleteAsync(List<T> entities) {
        return this.deleteAsync(entities, (Consumer<SQLException>)null);
    }

    public CompletableFuture<Void> deleteAsync(List<T> entities, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.delete(entities), exceptionHandling));
    }

    public CompletableFuture<Void> deleteAsync(T ... entities) {
        return this.deleteAsync(null, (BaseEntity[])entities);
    }

    public CompletableFuture<Void> deleteAsync(Consumer<SQLException> exceptionHandling, T ... entities) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.delete(Arrays.asList(entities)), exceptionHandling));
    }

    public CompletableFuture<Void> deleteAsync(long ... ids) {
        return this.deleteAsync((Consumer<SQLException>)null, ids);
    }

    public CompletableFuture<Void> deleteAsync(Consumer<SQLException> exceptionHandling, long ... ids) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.delete(ids), exceptionHandling));
    }

    public CompletableFuture<Void> deleteAsync(SqlPredicate<T> predicate) {
        return this.deleteAsync(predicate, (Consumer<SQLException>)null);
    }

    public CompletableFuture<Void> deleteAsync(SqlPredicate<T> predicate, Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.delete(predicate), exceptionHandling));
    }

    public CompletableFuture<Void> truncateTableAsync() {
        return this.truncateTableAsync(null);
    }

    public CompletableFuture<Void> truncateTableAsync(Consumer<SQLException> exceptionHandling) {
        return CompletableFuture.runAsync(Utilities.runnableHandling(() -> super.truncateTable(), exceptionHandling));
    }
}

