/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.SingleEntityQuery;
import com.github.collinalpert.java2db.queries.SingleQueryable;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.trigersoft.jaque.expression.LambdaExpression;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;

public class SingleEntityProjectionQuery<E extends BaseEntity, R>
implements SingleQueryable<R> {
    protected final Class<R> returnType;
    private final SqlFunction<E, R> projection;
    protected final SingleEntityQuery<E> originalQuery;

    public SingleEntityProjectionQuery(SqlFunction<E, R> projection, SingleEntityQuery<E> originalQuery) {
        LambdaExpression<SqlFunction<E, R>> lambda = LambdaExpression.parse(projection);
        this.returnType = lambda.getBody().getResultType();
        this.projection = projection;
        this.originalQuery = originalQuery;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<R> first() {
        try (DBConnection connection = new DBConnection();){
            Optional optional;
            block17: {
                ResultSet result;
                block15: {
                    Optional<R> optional2;
                    block16: {
                        result = connection.execute(this.getQuery());
                        try {
                            if (!result.next()) break block15;
                            optional2 = Optional.ofNullable(result.getObject(1, this.returnType));
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (result == null) break block17;
                result.close();
            }
            return optional;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    @Override
    public String getQuery() {
        StringBuilder builder = new StringBuilder("select ");
        String tableName = this.originalQuery.getTableName();
        String columnName = Lambda2Sql.toSql(this.projection, tableName);
        builder.append(columnName).append(" from `").append(tableName).append("`");
        builder.append(this.originalQuery.getQueryClauses(tableName));
        return builder.toString();
    }
}

