/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import com.github.collinalpert.expressions.expression.BinaryExpression;
import com.github.collinalpert.expressions.expression.ConstantExpression;
import com.github.collinalpert.expressions.expression.DelegateExpression;
import com.github.collinalpert.expressions.expression.ExpressionClassCracker;
import com.github.collinalpert.expressions.expression.ExpressionVisitor;
import com.github.collinalpert.expressions.expression.Interpreter;
import com.github.collinalpert.expressions.expression.InvocableExpression;
import com.github.collinalpert.expressions.expression.InvocationExpression;
import com.github.collinalpert.expressions.expression.LambdaExpression;
import com.github.collinalpert.expressions.expression.MemberExpression;
import com.github.collinalpert.expressions.expression.ParameterExpression;
import com.github.collinalpert.expressions.expression.TypeConverter;
import com.github.collinalpert.expressions.expression.UnaryExpression;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;

public abstract class Expression {
    private static final Map<Method, Class<?>> _boxers;
    private static final Map<Method, Class<?>> _unboxers;
    private final int expressionType;
    private final Class<?> resultType;

    protected Expression(int expressionType, @NonNull Class<?> resultType) {
        if (resultType == null) {
            throw new NullPointerException("resultType is marked non-null but is null");
        }
        this.expressionType = expressionType;
        this.resultType = resultType;
    }

    private static boolean isNumeric(Class<?> type) {
        if (Expression.isIntegral(type)) {
            return true;
        }
        if (type.isPrimitive()) {
            return type == Float.TYPE || type == Double.TYPE;
        }
        return type == Float.class || type == Double.class || type == BigDecimal.class;
    }

    private static boolean isIntegral(Class<?> type) {
        if (!type.isPrimitive()) {
            return type == Byte.class || type == Integer.class || type == Long.class || type == Short.class || type == BigInteger.class;
        }
        return type == Byte.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE;
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    private static Expression stripQuotesAndConverts(Expression e) {
        while (e.getExpressionType() == 8) {
            e = ((UnaryExpression)e).getFirst();
        }
        return e;
    }

    public static BinaryExpression add(Expression first, Expression second) {
        return Expression.createNumeric(0, first, second);
    }

    public static BinaryExpression divide(Expression first, Expression second) {
        return Expression.createNumeric(9, first, second);
    }

    public static BinaryExpression subtract(Expression first, Expression second) {
        return Expression.createNumeric(35, first, second);
    }

    public static BinaryExpression multiply(Expression first, Expression second) {
        return Expression.createNumeric(25, first, second);
    }

    public static BinaryExpression modulo(Expression first, Expression second) {
        return Expression.createNumeric(24, first, second);
    }

    public static BinaryExpression greaterThan(Expression first, Expression second) {
        return Expression.createNumericComparison(12, first, second);
    }

    public static BinaryExpression greaterThanOrEqual(Expression first, Expression second) {
        return Expression.createNumericComparison(13, first, second);
    }

    public static BinaryExpression lessThan(Expression first, Expression second) {
        return Expression.createNumericComparison(20, first, second);
    }

    public static BinaryExpression lessThanOrEqual(Expression first, Expression second) {
        return Expression.createNumericComparison(21, first, second);
    }

    private static BinaryExpression createNumericComparison(int expressionType, Expression first, Expression second) {
        if (!first.isComparable() || !second.isComparable()) {
            if (!first.isNumeric()) {
                throw new IllegalArgumentException(first.getResultType().toString());
            }
            if (!second.isNumeric()) {
                throw new IllegalArgumentException(second.getResultType().toString());
            }
        }
        return new BinaryExpression(expressionType, Boolean.TYPE, null, first, second);
    }

    private static BinaryExpression createNumeric(int expressionType, Expression first, Expression second) {
        boolean isFirstNumeric = first.isNumeric();
        boolean isSecondNumeric = second.isNumeric();
        if (!isFirstNumeric || !isSecondNumeric) {
            if (!isFirstNumeric && !isSecondNumeric) {
                throw new IllegalArgumentException("At least one argument must be numeric, got: " + first.getResultType().toString() + "," + second.getResultType().toString());
            }
            if (!isFirstNumeric) {
                first = TypeConverter.convert(first, second.getResultType());
            } else {
                second = TypeConverter.convert(second, first.getResultType());
            }
        }
        return new BinaryExpression(expressionType, first.getResultType(), null, first, second);
    }

    private static BinaryExpression createIntegral(int expressionType, Expression first, Expression second) {
        if (!first.isIntegral()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (!second.isIntegral()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return new BinaryExpression(expressionType, first.getResultType(), null, first, second);
    }

    public static BinaryExpression leftShift(Expression first, Expression second) {
        return Expression.createIntegral(19, first, second);
    }

    public static BinaryExpression rightShift(Expression first, Expression second) {
        return Expression.createIntegral(34, first, second);
    }

    public static BinaryExpression coalesce(Expression first, Expression second) {
        if (first.getResultType().isPrimitive()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (second.getResultType().isPrimitive()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return new BinaryExpression(5, first.getResultType(), null, first, second);
    }

    public static Expression equal(Expression first, Expression second) {
        if (first.getResultType() != second.getResultType()) {
            throw new IllegalArgumentException(first.getResultType().toString() + " != " + second.getResultType().toString());
        }
        return Expression.createBooleanExpression(10, first, second);
    }

    public static Expression notEqual(Expression first, Expression second) {
        if (first.getResultType() != second.getResultType()) {
            throw new IllegalArgumentException(first.getResultType().toString() + " != " + second.getResultType().toString());
        }
        return Expression.createBooleanExpression(30, first, second);
    }

    public static Expression logicalAnd(Expression first, Expression second) {
        if (!first.isBoolean()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (!second.isBoolean()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return Expression.createBooleanExpression(2, first, second);
    }

    public static BinaryExpression bitwiseAnd(Expression first, Expression second) {
        return Expression.createIntegral(1, first, second);
    }

    public static Expression logicalOr(Expression first, Expression second) {
        if (!first.isBoolean()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (!second.isBoolean()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return Expression.createBooleanExpression(32, first, second);
    }

    public static BinaryExpression bitwiseOr(Expression first, Expression second) {
        return Expression.createIntegral(31, first, second);
    }

    public static Expression exclusiveOr(Expression first, Expression second) {
        ConstantExpression constantExpression;
        if (second.getExpressionType() == 7 && Expression.isIntegral((constantExpression = (ConstantExpression)second).getResultType()) && ((Number)constantExpression.getValue()).intValue() == -1) {
            return Expression.bitwiseNot(first);
        }
        return Expression.createIntegral(11, first, second);
    }

    public static UnaryExpression arrayLength(Expression array) {
        if (!array.getResultType().isArray()) {
            throw new IllegalArgumentException(array.getResultType().toString());
        }
        return new UnaryExpression(4, Integer.TYPE, array);
    }

    public static BinaryExpression arrayIndex(Expression array, Expression index) {
        Class<?> arrayType = array.getResultType();
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(arrayType.toString());
        }
        if (index.getResultType() != Integer.TYPE) {
            throw new IllegalArgumentException("index:" + index.getResultType().toString());
        }
        return new BinaryExpression(3, arrayType.getComponentType(), null, array, index);
    }

    public static Expression convert(Expression e, Class<?> to) {
        if (e.getResultType() == to) {
            return e;
        }
        return new UnaryExpression(8, to, e);
    }

    public static ConstantExpression constant(Object value, Class<?> resultType) {
        return new ConstantExpression(resultType, value);
    }

    public static ConstantExpression constant(Object value) {
        Class type = value == null ? Object.class : value.getClass();
        return Expression.constant(value, type);
    }

    public static UnaryExpression negate(Expression e) {
        if (!e.isNumeric()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        return new UnaryExpression(26, e.getResultType(), e);
    }

    public static ParameterExpression parameter(Class<?> resultType, int index) {
        return new ParameterExpression(resultType, index);
    }

    public static BinaryExpression instanceOf(Expression e, Class<?> type) {
        return Expression.instanceOf(e, Expression.constant(type));
    }

    public static BinaryExpression instanceOf(Expression e, Expression type) {
        return new BinaryExpression(36, Boolean.TYPE, null, e, type);
    }

    public static Expression unary(int expressionType, Class<?> resultType, Expression operand) {
        switch (expressionType) {
            case 8: {
                return Expression.convert(operand, resultType);
            }
            case 4: {
                return Expression.arrayLength(operand);
            }
            case 26: {
                return Expression.negate(operand);
            }
            case 28: {
                return Expression.bitwiseNot(operand);
            }
            case 29: {
                return Expression.logicalNot(operand);
            }
            case 15: {
                return Expression.isNull(operand);
            }
            case 16: {
                return Expression.isNonNull(operand);
            }
        }
        throw new IllegalArgumentException("expressionType");
    }

    public static Expression binary(int expressionType, Expression first, Expression second) {
        return Expression.binary(expressionType, null, first, second);
    }

    public static Expression binary(int expressionType, Expression operator, Expression first, Expression second) {
        switch (expressionType) {
            case 0: {
                return Expression.add(first, second);
            }
            case 1: {
                return Expression.bitwiseAnd(first, second);
            }
            case 2: {
                return Expression.logicalAnd(first, second);
            }
            case 3: {
                return Expression.arrayIndex(first, second);
            }
            case 5: {
                return Expression.coalesce(first, second);
            }
            case 6: {
                return Expression.condition(operator, first, second);
            }
            case 9: {
                return Expression.divide(first, second);
            }
            case 10: {
                return Expression.equal(first, second);
            }
            case 11: {
                return Expression.exclusiveOr(first, second);
            }
            case 12: {
                return Expression.greaterThan(first, second);
            }
            case 13: {
                return Expression.greaterThanOrEqual(first, second);
            }
            case 19: {
                return Expression.leftShift(first, second);
            }
            case 20: {
                return Expression.lessThan(first, second);
            }
            case 21: {
                return Expression.lessThanOrEqual(first, second);
            }
            case 24: {
                return Expression.modulo(first, second);
            }
            case 25: {
                return Expression.multiply(first, second);
            }
            case 30: {
                return Expression.notEqual(first, second);
            }
            case 31: {
                return Expression.bitwiseOr(first, second);
            }
            case 32: {
                return Expression.logicalOr(first, second);
            }
            case 34: {
                return Expression.rightShift(first, second);
            }
            case 35: {
                return Expression.subtract(first, second);
            }
            case 36: {
                return Expression.instanceOf(first, second);
            }
        }
        throw new IllegalArgumentException("expressionType");
    }

    private static Expression createBooleanExpression(int expressionType, Expression first, Expression second) {
        Expression toLeave;
        Expression toReduce;
        if (first.getExpressionType() == 7) {
            toReduce = first;
            toLeave = second;
        } else if (second.getExpressionType() == 7) {
            toReduce = second;
            toLeave = first;
        } else {
            toReduce = null;
            toLeave = null;
        }
        if (toLeave != null && toLeave.isBoolean()) {
            toReduce = TypeConverter.convert(toReduce, Boolean.TYPE);
            switch (expressionType) {
                case 10: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? toLeave : Expression.logicalNot(toLeave);
                }
                case 30: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? Expression.logicalNot(toLeave) : toLeave;
                }
                case 2: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? toLeave : toReduce;
                }
                case 32: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? toReduce : toLeave;
                }
            }
        }
        return new BinaryExpression(expressionType, Boolean.TYPE, null, first, second);
    }

    public static LambdaExpression lambda(Class<?> resultType, Expression body, List<ParameterExpression> parameters) {
        return new LambdaExpression(resultType, body, parameters);
    }

    public static DelegateExpression delegate(Class<?> resultType, Expression delegate, List<ParameterExpression> parameters) {
        return new DelegateExpression(resultType, delegate, parameters);
    }

    public static MemberExpression get(Class<?> type, String name) throws NoSuchFieldException {
        return Expression.get(null, type.getDeclaredField(name));
    }

    public static MemberExpression get(Expression instance, String name) throws NoSuchFieldException {
        return Expression.get(instance, instance.getResultType().getDeclaredField(name));
    }

    public static MemberExpression member(int expressionType, Expression instance, Member member, Class<?> resultType, List<ParameterExpression> params) {
        return new MemberExpression(expressionType, instance, member, resultType, params);
    }

    public static MemberExpression get(Expression instance, Field field) {
        return Expression.member(22, instance, field, field.getType(), Collections.emptyList());
    }

    public static Expression invoke(Expression instance, Method method, Expression ... arguments) {
        return Expression.invoke(instance, method, List.of(arguments));
    }

    public static Expression invoke(Expression instance, Method method, List<Expression> arguments) {
        Class<?> boxer;
        Expression e;
        if (instance != null) {
            Class<?> primitive;
            if (!instance.getResultType().isPrimitive() && (primitive = _unboxers.get(method)) != null) {
                return Expression.convert(instance, primitive);
            }
        } else if (arguments.size() == 1 && (e = arguments.get(0)).getResultType().isPrimitive() && (boxer = _boxers.get(method)) != null) {
            return Expression.convert(e, boxer);
        }
        if (method.isSynthetic()) {
            Object actualInstance = instance != null ? ((Function)instance.accept(Interpreter.Instance)).apply(null) : null;
            LambdaExpression lambdaExpression = ExpressionClassCracker.getInstance().lambdaFromFileSystem(actualInstance, method);
            return Expression.invoke((InvocableExpression)lambdaExpression, arguments);
        }
        return Expression.invoke((InvocableExpression)Expression.member(23, instance, method, method.getReturnType(), Expression.getParameters(method)), arguments);
    }

    public static InvocationExpression invoke(InvocableExpression method, Expression ... arguments) {
        return Expression.invoke(method, Arrays.asList(arguments));
    }

    public static InvocationExpression invoke(InvocableExpression method, List<Expression> arguments) {
        arguments = new ArrayList<Expression>(arguments);
        method = ExpressionClassCracker.getInstance().parseSyntheticArguments(method, arguments);
        return new InvocationExpression(method, arguments);
    }

    private static List<ParameterExpression> getParameters(Member member) {
        Class<?>[] params;
        if (member instanceof Constructor) {
            Constructor ctor = (Constructor)member;
            params = ctor.getParameterTypes();
        } else {
            Method m = (Method)member;
            params = m.getParameterTypes();
        }
        ArrayList<ParameterExpression> parameterList = new ArrayList<ParameterExpression>(params.length);
        for (int i = 0; i < params.length; ++i) {
            parameterList.add(Expression.parameter(params[i], i));
        }
        return Collections.unmodifiableList(parameterList);
    }

    public static InvocationExpression newInstance(Constructor<?> method, Expression ... arguments) {
        return Expression.newInstance(method, List.of(arguments));
    }

    public static InvocationExpression newInstance(Constructor<?> method, List<Expression> arguments) {
        return Expression.invoke((InvocableExpression)Expression.member(27, null, method, method.getDeclaringClass(), Expression.getParameters(method)), arguments);
    }

    public static InvocationExpression newInstance(Class<?> type, Class<?>[] argumentTypes, Expression ... arguments) throws NoSuchMethodException {
        return Expression.newInstance(type.getConstructor(argumentTypes), arguments);
    }

    public static Expression invoke(Expression instance, String name, Class<?>[] parameterTypes, Expression ... arguments) throws NoSuchMethodException {
        return Expression.invoke(instance, Expression.getDeclaredMethod(instance.getResultType(), name, parameterTypes), arguments);
    }

    public static Expression invoke(Class<?> type, String name, Class<?>[] parameterTypes, Expression ... arguments) throws NoSuchMethodException {
        return Expression.invoke(null, Expression.getDeclaredMethod(type, name, parameterTypes), arguments);
    }

    private static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Class<?> tmpClass = clazz;
        while (true) {
            try {
                return tmpClass.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                Class<?> thisClass;
                if ((tmpClass = (thisClass = tmpClass).getSuperclass()) != null) continue;
                return thisClass.getMethod(name, parameterTypes);
            }
            break;
        }
    }

    public static Expression condition(Expression test, Expression ifTrue, Expression ifFalse) {
        if (!test.isBoolean()) {
            throw new IllegalArgumentException("test is " + test.getResultType());
        }
        if (ifTrue.isBoolean()) {
            Expression ifTrueStripped = Expression.stripQuotesAndConverts(ifTrue);
            Expression ifFalseStripped = Expression.stripQuotesAndConverts(ifFalse);
            if (ifTrueStripped.getExpressionType() == 7 && ifFalseStripped.getExpressionType() == 7) {
                ConstantExpression firstConstant = (ConstantExpression)ifTrueStripped;
                ConstantExpression secondConstant = (ConstantExpression)ifFalseStripped;
                if (firstConstant.getValue().equals(secondConstant.getValue())) {
                    return ifTrue;
                }
                return Expression.convert((Boolean)firstConstant.getValue() != false ? test : Expression.logicalNot(test), ifTrue.getResultType());
            }
        }
        return new BinaryExpression(6, ifTrue.getResultType(), test, ifTrue, ifFalse);
    }

    public static UnaryExpression isNull(Expression e) {
        if (e.getResultType().isPrimitive()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        return new UnaryExpression(15, Boolean.TYPE, e);
    }

    public static UnaryExpression isNonNull(Expression e) {
        if (e.getResultType().isPrimitive()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        return new UnaryExpression(16, Boolean.TYPE, e);
    }

    public static UnaryExpression bitwiseNot(Expression e) {
        if (!e.isIntegral()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        return new UnaryExpression(28, e.getResultType(), e);
    }

    public static Expression logicalNot(Expression e) {
        int type;
        if (!e.isBoolean()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        switch (e.getExpressionType()) {
            case 6: {
                BinaryExpression be = (BinaryExpression)e;
                return Expression.condition(be.getOperator(), Expression.logicalNot(be.getFirst()), Expression.logicalNot(be.getSecond()));
            }
            case 7: {
                ConstantExpression ce = (ConstantExpression)e;
                return Expression.constant((Boolean)ce.getValue() == false, ce.getResultType());
            }
            case 29: {
                UnaryExpression ue = (UnaryExpression)e;
                return ue.getFirst();
            }
            case 15: {
                UnaryExpression ue = (UnaryExpression)e;
                return Expression.isNonNull(ue.getFirst());
            }
            case 16: {
                UnaryExpression ue = (UnaryExpression)e;
                return Expression.isNull(ue.getFirst());
            }
            case 2: {
                BinaryExpression be = (BinaryExpression)e;
                return Expression.convert(Expression.logicalOr(Expression.logicalNot(be.getFirst()), Expression.logicalNot(be.getSecond())), be.getResultType());
            }
            case 32: {
                BinaryExpression be = (BinaryExpression)e;
                return Expression.convert(Expression.logicalAnd(Expression.logicalNot(be.getFirst()), Expression.logicalNot(be.getSecond())), be.getResultType());
            }
            case 10: {
                type = 30;
                break;
            }
            case 12: {
                type = 21;
                break;
            }
            case 13: {
                type = 20;
                break;
            }
            case 20: {
                type = 13;
                break;
            }
            case 21: {
                type = 12;
                break;
            }
            case 30: {
                type = 10;
                break;
            }
            default: {
                return new UnaryExpression(29, e.getResultType(), e);
            }
        }
        BinaryExpression be = (BinaryExpression)e;
        return Expression.binary(type, be.getFirst(), be.getSecond());
    }

    private boolean isComparable() {
        return Comparable.class.isAssignableFrom(this.getResultType());
    }

    private boolean isNumeric() {
        return Expression.isNumeric(this.getResultType());
    }

    private boolean isIntegral() {
        return Expression.isIntegral(this.getResultType());
    }

    private boolean isBoolean() {
        return Expression.isBoolean(this.getResultType());
    }

    public final <T> T accept(ExpressionVisitor<T> v) {
        return this.visit(v);
    }

    protected abstract <T> T visit(ExpressionVisitor<T> var1);

    public int getExpressionType() {
        return this.expressionType;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpressionType() != other.getExpressionType()) {
            return false;
        }
        Class<?> this$resultType = this.getResultType();
        Class<?> other$resultType = other.getResultType();
        return !(this$resultType == null ? other$resultType != null : !this$resultType.equals(other$resultType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Expression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpressionType();
        Class<?> $resultType = this.getResultType();
        result = result * 59 + ($resultType == null ? 43 : $resultType.hashCode());
        return result;
    }

    static {
        _unboxers = new HashMap(8);
        _boxers = new HashMap(8);
        try {
            _unboxers.put(Boolean.class.getMethod("booleanValue", new Class[0]), Boolean.TYPE);
            _unboxers.put(Byte.class.getMethod("byteValue", new Class[0]), Byte.TYPE);
            _unboxers.put(Character.class.getMethod("charValue", new Class[0]), Character.TYPE);
            _unboxers.put(Double.class.getMethod("doubleValue", new Class[0]), Double.TYPE);
            _unboxers.put(Float.class.getMethod("floatValue", new Class[0]), Float.TYPE);
            _unboxers.put(Integer.class.getMethod("intValue", new Class[0]), Integer.TYPE);
            _unboxers.put(Long.class.getMethod("longValue", new Class[0]), Long.TYPE);
            _unboxers.put(Short.class.getMethod("shortValue", new Class[0]), Short.TYPE);
            _boxers.put(Boolean.class.getMethod("valueOf", Boolean.TYPE), Boolean.class);
            _boxers.put(Byte.class.getMethod("valueOf", Byte.TYPE), Byte.class);
            _boxers.put(Character.class.getMethod("valueOf", Character.TYPE), Character.class);
            _boxers.put(Double.class.getMethod("valueOf", Double.TYPE), Double.class);
            _boxers.put(Float.class.getMethod("valueOf", Float.TYPE), Float.class);
            _boxers.put(Integer.class.getMethod("valueOf", Integer.TYPE), Integer.class);
            _boxers.put(Long.class.getMethod("valueOf", Long.TYPE), Long.class);
            _boxers.put(Short.class.getMethod("valueOf", Short.TYPE), Short.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

