/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import com.github.collinalpert.expressions.expression.Expression;
import com.github.collinalpert.expressions.expression.ExpressionClassCracker;
import com.github.collinalpert.expressions.expression.ExpressionVisitor;
import com.github.collinalpert.expressions.expression.Interpreter;
import com.github.collinalpert.expressions.expression.InvocableExpression;
import com.github.collinalpert.expressions.expression.ParameterExpression;
import com.github.collinalpert.expressions.expression.TypeConverter;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;

public final class LambdaExpression
extends InvocableExpression {
    private final Expression body;

    LambdaExpression(Class<?> resultType, @NonNull Expression body, List<ParameterExpression> params) {
        super(17, resultType, params);
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (!TypeConverter.isAssignable(resultType, body.getResultType())) {
            throw new IllegalArgumentException(body.getResultType() + " is not assignable to " + resultType);
        }
        this.body = body;
    }

    public static LambdaExpression parse(Object lambda) {
        return ExpressionClassCracker.getInstance().lambda(lambda);
    }

    public Function<Object[], ?> compile() {
        Function f = (Function)this.accept(Interpreter.Instance);
        return pp -> {
            Function f1 = (Function)f.apply(pp);
            return f1.apply(null);
        };
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        List<ParameterExpression> arguments = this.getParameters();
        if (arguments.size() > 0) {
            b.append('(');
            for (int i = 0; i < arguments.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                    b.append(' ');
                }
                ParameterExpression pe = arguments.get(i);
                b.append(pe.getResultType().getName());
                b.append(' ');
                b.append(pe.toString());
            }
            b.append(')');
        }
        b.append(" -> ");
        b.append(this.getBody().toString());
        b.append('}');
        return b.toString();
    }

    public Expression getBody() {
        return this.body;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression other = (LambdaExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$body = this.getBody();
        Expression other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LambdaExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }
}

