/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.TypeConverter;
import java.util.List;

public final class InvocationExpression
extends Expression {
    private final InvocableExpression target;
    private final List<Expression> arguments;

    InvocationExpression(InvocableExpression method, List<Expression> arguments) {
        super(14, method.getResultType());
        List<ParameterExpression> pp = method.getParameters();
        for (int i = 0; i < pp.size(); ++i) {
            Class<?> paramType;
            Class<?> resultType = arguments.get(i).getResultType();
            if (resultType == Object.class || TypeConverter.isAssignable(paramType = pp.get(i).getResultType(), resultType) || paramType.isInterface() && resultType == LambdaExpression.class) continue;
            throw new IllegalArgumentException(String.valueOf(i));
        }
        this.target = method;
        this.arguments = arguments;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        InvocableExpression normalized = this.getTarget();
        b.append(normalized.toString());
        if (normalized.getExpressionType() != 21) {
            b.append('(');
            List<ParameterExpression> parameters = normalized.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                    b.append(' ');
                }
                b.append(this.arguments.get(parameters.get(i).getIndex()).toString());
            }
            b.append(')');
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationExpression)) {
            return false;
        }
        InvocationExpression other = (InvocationExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvocableExpression this$target = this.getTarget();
        InvocableExpression other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        List<Expression> this$arguments = this.getArguments();
        List<Expression> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InvocationExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        InvocableExpression $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        List<Expression> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public InvocableExpression getTarget() {
        return this.target;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }
}

