/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import com.github.collinalpert.expressions.expression.Expression;
import com.github.collinalpert.expressions.expression.ExpressionVisitor;
import com.github.collinalpert.expressions.expression.InvocableExpression;
import com.github.collinalpert.expressions.expression.ParameterExpression;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.List;

public final class MemberExpression
extends InvocableExpression {
    private final Expression instance;
    private final Member member;

    MemberExpression(int expressionType, Expression instance, Member member, Class<?> resultType, List<ParameterExpression> params) {
        super(expressionType, resultType, params);
        this.instance = instance;
        this.member = member;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        Member m = this.getMember();
        String me = this.getInstance() != null ? this.getInstance().toString() : m.getDeclaringClass().getSimpleName();
        return me + "." + (m instanceof Constructor ? "<new>" : m.getName());
    }

    public Expression getInstance() {
        return this.instance;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberExpression)) {
            return false;
        }
        MemberExpression other = (MemberExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$instance = this.getInstance();
        Expression other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance)) {
            return false;
        }
        Member this$member = this.getMember();
        Member other$member = other.getMember();
        return !(this$member == null ? other$member != null : !this$member.equals(other$member));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MemberExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
        Member $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : $member.hashCode());
        return result;
    }
}

