/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import com.github.collinalpert.expressions.expression.BinaryExpression;
import com.github.collinalpert.expressions.expression.ConstantExpression;
import com.github.collinalpert.expressions.expression.DelegateExpression;
import com.github.collinalpert.expressions.expression.Expression;
import com.github.collinalpert.expressions.expression.ExpressionType;
import com.github.collinalpert.expressions.expression.ExpressionVisitor;
import com.github.collinalpert.expressions.expression.InvocableExpression;
import com.github.collinalpert.expressions.expression.InvocationExpression;
import com.github.collinalpert.expressions.expression.LambdaExpression;
import com.github.collinalpert.expressions.expression.MemberExpression;
import com.github.collinalpert.expressions.expression.ParameterExpression;
import com.github.collinalpert.expressions.expression.UnaryExpression;
import com.github.collinalpert.expressions.function.Functions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

final class Interpreter
implements ExpressionVisitor<Function<Object[], ?>> {
    static final Interpreter Instance = new Interpreter();
    private static final Object[] emptyArray = new Object[0];

    private Interpreter() {
    }

    private static Function<Object[], ?> toClosure(Function<Object[], ?> f) {
        return captured -> p -> f.apply(Interpreter.concat(captured, p));
    }

    private static <T> T[] concat(T[] first, T[] second) {
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private Function<Object[], ?> normalize(BiFunction<Object[], Object[], ?> source) {
        return pp -> source.apply((Object[])pp, (Object[])pp);
    }

    private Function<Object[], Boolean> normalize(BiPredicate<Object[], Object[]> source) {
        return pp -> source.test((Object[])pp, (Object[])pp);
    }

    private Function<Object[], Boolean> normalize(Predicate<Object[]> source) {
        return source::test;
    }

    @Override
    public Function<Object[], ?> visit(BinaryExpression e) {
        Function first = (Function)e.getFirst().accept(this);
        Function second = (Function)e.getSecond().accept(this);
        switch (e.getExpressionType()) {
            case 0: {
                return this.normalize(Functions.add(first, second));
            }
            case 1: {
                return this.normalize(Functions.bitwiseAnd(first, second));
            }
            case 2: {
                return this.normalize(Functions.and(first, second));
            }
            case 3: {
                return t -> Array.get(first.apply(t), (Integer)second.apply(t));
            }
            case 6: {
                return Functions.iif((Function)e.getOperator().accept(this), first, second);
            }
            case 9: {
                return this.normalize(Functions.divide(first, second));
            }
            case 10: {
                return this.normalize(Functions.equal(first, second));
            }
            case 11: {
                return this.normalize(Functions.xor(first, second));
            }
            case 12: {
                return this.normalize(Functions.greaterThan(first, second));
            }
            case 13: {
                return this.normalize(Functions.greaterThanOrEqual(first, second));
            }
            case 19: {
                return this.normalize(Functions.shiftLeft(first, second));
            }
            case 20: {
                return this.normalize(Functions.lessThan(first, second));
            }
            case 21: {
                return this.normalize(Functions.lessThanOrEqual(first, second));
            }
            case 24: {
                return this.normalize(Functions.modulo(first, second));
            }
            case 25: {
                return this.normalize(Functions.multiply(first, second));
            }
            case 30: {
                return this.normalize(Functions.equal(first, second).negate());
            }
            case 31: {
                return this.normalize(Functions.bitwiseOr(first, second));
            }
            case 32: {
                return this.normalize(Functions.or(first, second));
            }
            case 34: {
                return this.normalize(Functions.shiftRight(first, second));
            }
            case 35: {
                return this.normalize(Functions.subtract(first, second));
            }
            case 36: {
                return this.normalize(Functions.instanceOf(first, (Class)second.apply(null)));
            }
        }
        throw new IllegalArgumentException(ExpressionType.toString(e.getExpressionType()));
    }

    @Override
    public Function<Object[], ?> visit(ConstantExpression e) {
        return Functions.constant(e.getValue());
    }

    @Override
    public Function<Object[], ?> visit(InvocationExpression e) {
        InvocableExpression target = e.getTarget();
        Function<Object[], Object> m = (Function<Object[], Object>)target.accept(this);
        Function<Object[], Object> x = target.getExpressionType() == 17 ? pp -> {
            Function f1 = (Function)m.apply((Object[])pp);
            return f1.apply(emptyArray);
        } : m;
        int size = e.getArguments().size();
        ArrayList<Function> ppe = new ArrayList<Function>(size);
        for (Expression p : e.getArguments()) {
            ppe.add((Function)p.accept(this));
        }
        Function<Object[], Object[]> params = pp -> {
            Object[] objectArray;
            if (target.getExpressionType() == 22) {
                return pp;
            }
            Object[] r = new Object[ppe.size()];
            int index = 0;
            for (Function pe : ppe) {
                r[index++] = pe.apply(pp);
            }
            if (target.getExpressionType() == 23 || target.getExpressionType() == 18) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = pp;
                objectArray = objectArray2;
                objectArray2[1] = r;
            } else {
                objectArray = r;
            }
            return objectArray;
        };
        return x.compose(params);
    }

    @Override
    public Function<Object[], ?> visit(LambdaExpression e) {
        Function f = (Function)e.getBody().accept(this);
        return Interpreter.toClosure(f.compose(this.visitParameters(e)));
    }

    private Function<Object[], Object[]> visitParameters(InvocableExpression invocable) {
        List<ParameterExpression> parameters = invocable.getParameters();
        int size = parameters.size();
        ArrayList<Function> ppe = new ArrayList<Function>(size);
        for (ParameterExpression p : parameters) {
            ppe.add((Function)p.accept(this));
        }
        return pp -> {
            Object[] r = new Object[ppe.size()];
            int index = 0;
            for (Function pe : ppe) {
                r[((ParameterExpression)parameters.get((int)index++)).getIndex()] = pe.apply(pp);
            }
            return r;
        };
    }

    @Override
    public Function<Object[], ?> visit(DelegateExpression e) {
        Function f = (Function)e.getDelegate().accept(this);
        Function<Object[], Object[]> params = this.visitParameters(e);
        return t -> {
            InvocableExpression l = (InvocableExpression)f.apply((Object[])t[0]);
            Function f1 = (Function)((Function)l.accept(this)).apply((Object[])params.apply((Object[])t[1]));
            return l.getExpressionType() == 17 ? f1.apply(emptyArray) : f1;
        };
    }

    @Override
    public Function<Object[], ?> visit(MemberExpression e) {
        Expression ei;
        Member m = e.getMember();
        if (m instanceof AccessibleObject) {
            AccessibleObject ao = (AccessibleObject)((Object)m);
            try {
                if (!ao.isAccessible()) {
                    ao.setAccessible(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Function instance = (ei = e.getInstance()) != null ? (Function)ei.accept(this) : null;
        Function<Object[], Object[]> params = this.visitParameters(e);
        Function<Object[], Object> field = t -> {
            try {
                return ((Field)m).get(instance == null ? null : instance.apply(t));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        };
        Function<Object[], Object> method = t -> {
            Object inst = instance != null ? instance.apply((Object[])t[0]) : null;
            try {
                Object[] pp = (Object[])params.apply((Object[])t[1]);
                return ((Method)m).invoke(inst, pp);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        };
        Function<Object[], Object> ctor = t -> {
            try {
                return ((Constructor)m).newInstance((Object[])params.apply((Object[])t));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        };
        Function<Object[], Object> member = m instanceof Field ? field : (m instanceof Method ? method : ctor);
        return member;
    }

    @Override
    public Function<Object[], ?> visit(ParameterExpression e) {
        int index = e.getIndex();
        return t -> t[index];
    }

    @Override
    public Function<Object[], ?> visit(UnaryExpression e) {
        Function first = (Function)e.getFirst().accept(this);
        switch (e.getExpressionType()) {
            case 4: {
                return t -> Array.getLength(first.apply(t));
            }
            case 28: {
                return Functions.bitwiseNot(first);
            }
            case 8: {
                Class<?> to = e.getResultType();
                if (to.isPrimitive() || Number.class.isAssignableFrom(to)) {
                    return t -> {
                        Object source = first.apply(t);
                        if (source instanceof Number) {
                            Number result = (Number)source;
                            if (to.isPrimitive()) {
                                if (to == Integer.TYPE) {
                                    return result.intValue();
                                }
                                if (to == Long.TYPE) {
                                    return result.longValue();
                                }
                                if (to == Float.TYPE) {
                                    return Float.valueOf(result.floatValue());
                                }
                                if (to == Double.TYPE) {
                                    return result.doubleValue();
                                }
                                if (to == Byte.TYPE) {
                                    return result.byteValue();
                                }
                                if (to == Character.TYPE) {
                                    return Character.valueOf((char)result.intValue());
                                }
                                if (to == Short.TYPE) {
                                    return result.shortValue();
                                }
                            } else if (result != null) {
                                if (to == BigInteger.class) {
                                    return BigInteger.valueOf(result.longValue());
                                }
                                if (to == BigDecimal.class) {
                                    return BigDecimal.valueOf(result.doubleValue());
                                }
                            }
                        }
                        if (source instanceof Character) {
                            if (to == Character.TYPE) {
                                return Character.valueOf(((Character)source).charValue());
                            }
                            if (to == Integer.TYPE) {
                                return (int)((Character)source).charValue();
                            }
                            if (to == Long.TYPE) {
                                return (long)((Character)source).charValue();
                            }
                            if (to == Float.TYPE) {
                                return Float.valueOf(((Character)source).charValue());
                            }
                            if (to == Double.TYPE) {
                                return (double)((Character)source).charValue();
                            }
                        }
                        return to.cast(source);
                    };
                }
                return first;
            }
            case 15: {
                return first.andThen(r -> r == null);
            }
            case 16: {
                return first.andThen(r -> r != null);
            }
            case 29: {
                return this.normalize(Functions.not(first));
            }
            case 26: {
                return Functions.negate(first);
            }
        }
        throw new IllegalArgumentException(ExpressionType.toString(e.getExpressionType()));
    }
}

