/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import com.github.collinalpert.expressions.expression.Expression;
import com.github.collinalpert.expressions.expression.ExpressionType;
import com.github.collinalpert.expressions.expression.ExpressionVisitor;
import lombok.NonNull;

public class UnaryExpression
extends Expression {
    private final Expression first;

    UnaryExpression(int expressionType, Class<?> resultType, @NonNull Expression operand) {
        super(expressionType, resultType);
        if (operand == null) {
            throw new NullPointerException("operand is marked non-null but is null");
        }
        this.first = operand;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getExpressionType() == 8) {
            b.append('(');
            b.append(this.getResultType().getName());
            b.append(')');
        } else {
            b.append(ExpressionType.toString(this.getExpressionType()));
        }
        b.append(this.getFirst().toString());
        return b.toString();
    }

    public Expression getFirst() {
        return this.first;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnaryExpression)) {
            return false;
        }
        UnaryExpression other = (UnaryExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$first = this.getFirst();
        Expression other$first = other.getFirst();
        return !(this$first == null ? other$first != null : !((Object)this$first).equals(other$first));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnaryExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
        return result;
    }
}

