/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.lambda2sql;

import java.util.EmptyStackException;

public class LinkedListStack<T> {
    private Node head;
    private int elementCount;

    public void push(T element) {
        this.head = new Node(this.head, element);
        ++this.elementCount;
    }

    public T pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        Node firstElement = this.head;
        this.head = this.head.getNext();
        --this.elementCount;
        return firstElement.getValue();
    }

    public T top() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.head.getValue();
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int size() {
        return this.elementCount;
    }

    private class Node {
        private final Node next;
        private final T value;

        Node(Node next, T value) {
            this.next = next;
            this.value = value;
        }

        Node getNext() {
            return this.next;
        }

        T getValue() {
            return this.value;
        }
    }
}

