/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.lambda2sql;

import com.github.collinalpert.expressions.expression.BinaryExpression;
import com.github.collinalpert.expressions.expression.ConstantExpression;
import com.github.collinalpert.expressions.expression.DelegateExpression;
import com.github.collinalpert.expressions.expression.Expression;
import com.github.collinalpert.expressions.expression.ExpressionType;
import com.github.collinalpert.expressions.expression.ExpressionVisitor;
import com.github.collinalpert.expressions.expression.InvocableExpression;
import com.github.collinalpert.expressions.expression.InvocationExpression;
import com.github.collinalpert.expressions.expression.LambdaExpression;
import com.github.collinalpert.expressions.expression.MemberExpression;
import com.github.collinalpert.expressions.expression.ParameterExpression;
import com.github.collinalpert.expressions.expression.UnaryExpression;
import com.github.collinalpert.lambda2sql.LinkedListStack;
import com.github.collinalpert.lambda2sql.SqlFunctions;
import com.github.collinalpert.lambda2sql.functions.TriFunction;
import java.lang.reflect.Member;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SqlVisitor
implements ExpressionVisitor<StringBuilder> {
    private static final Map<Member, Integer> operatorMethods = new HashMap<Member, Integer>(8, 1.0f);
    private static final Map<Member, String> sqlFunctionMethods = new HashMap<Member, String>(4, 1.0f);
    private final String tableName;
    private final boolean withBackticks;
    private final LinkedListStack<List<ConstantExpression>> arguments;
    private final Map<String, Integer> parameterConsumptionCount;
    private final Map<Member, TriFunction<Expression, Expression, Boolean, StringBuilder>> javaMethods;
    private final StringBuilder sb;
    private Expression body;
    private Expression javaMethodParameter;

    SqlVisitor(String tableName, boolean withBackTicks) {
        this(tableName, withBackTicks, null, new LinkedListStack<List<ConstantExpression>>());
    }

    private SqlVisitor(String tableName, boolean withBackticks, Expression body, LinkedListStack<List<ConstantExpression>> arguments) {
        this.tableName = tableName;
        this.withBackticks = withBackticks;
        this.body = body;
        this.arguments = arguments;
        this.sb = new StringBuilder();
        this.parameterConsumptionCount = new HashMap<String, Integer>();
        this.javaMethods = new HashMap<Member, TriFunction<Expression, Expression, Boolean, StringBuilder>>(64, 1.0f);
        try {
            this.javaMethods.put(String.class.getDeclaredMethod("startsWith", String.class), this::stringStartsWith);
            this.javaMethods.put(String.class.getDeclaredMethod("endsWith", String.class), this::stringEndsWith);
            this.javaMethods.put(String.class.getDeclaredMethod("contains", CharSequence.class), this::stringContains);
            this.javaMethods.put(String.class.getDeclaredMethod("length", new Class[0]), this.applySqlFunction("LENGTH"));
            this.javaMethods.put(String.class.getDeclaredMethod("toLowerCase", new Class[0]), this.applySqlFunction("UPPER"));
            this.javaMethods.put(String.class.getDeclaredMethod("toUpperCase", new Class[0]), this.applySqlFunction("LOWER"));
            this.javaMethods.put(List.class.getDeclaredMethod("contains", Object.class), this::listContains);
            this.javaMethods.put(ArrayList.class.getDeclaredMethod("contains", Object.class), this::listContains);
            this.javaMethods.put(LinkedList.class.getDeclaredMethod("contains", Object.class), this::listContains);
            this.javaMethods.put(LocalTime.class.getDeclaredMethod("getSecond", new Class[0]), this.applySqlFunction("SECOND"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getSecond", new Class[0]), this.applySqlFunction("SECOND"));
            this.javaMethods.put(OffsetTime.class.getDeclaredMethod("getSecond", new Class[0]), this.applySqlFunction("SECOND"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getSecond", new Class[0]), this.applySqlFunction("SECOND"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getSecond", new Class[0]), this.applySqlFunction("SECOND"));
            this.javaMethods.put(LocalTime.class.getDeclaredMethod("getMinute", new Class[0]), this.applySqlFunction("MINUTE"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getMinute", new Class[0]), this.applySqlFunction("MINUTE"));
            this.javaMethods.put(OffsetTime.class.getDeclaredMethod("getMinute", new Class[0]), this.applySqlFunction("MINUTE"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getMinute", new Class[0]), this.applySqlFunction("MINUTE"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getMinute", new Class[0]), this.applySqlFunction("MINUTE"));
            this.javaMethods.put(LocalTime.class.getDeclaredMethod("getHour", new Class[0]), this.applySqlFunction("HOUR"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getHour", new Class[0]), this.applySqlFunction("HOUR"));
            this.javaMethods.put(OffsetTime.class.getDeclaredMethod("getHour", new Class[0]), this.applySqlFunction("HOUR"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getHour", new Class[0]), this.applySqlFunction("HOUR"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getHour", new Class[0]), this.applySqlFunction("HOUR"));
            this.javaMethods.put(LocalDate.class.getDeclaredMethod("getDayOfWeek", new Class[0]), this.applySqlFunction("DAYOFWEEK"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getDayOfWeek", new Class[0]), this.applySqlFunction("DAYOFWEEK"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getDayOfWeek", new Class[0]), this.applySqlFunction("DAYOFWEEK"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getDayOfWeek", new Class[0]), this.applySqlFunction("DAYOFWEEK"));
            this.javaMethods.put(LocalDate.class.getDeclaredMethod("getDayOfMonth", new Class[0]), this.applySqlFunction("DAY"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getDayOfWeek", new Class[0]), this.applySqlFunction("DAY"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getDayOfWeek", new Class[0]), this.applySqlFunction("DAY"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getDayOfWeek", new Class[0]), this.applySqlFunction("DAY"));
            this.javaMethods.put(LocalDate.class.getDeclaredMethod("getDayOfYear", new Class[0]), this.applySqlFunction("DAYOFYEAR"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getDayOfYear", new Class[0]), this.applySqlFunction("DAYOFYEAR"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getDayOfYear", new Class[0]), this.applySqlFunction("DAYOFYEAR"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getDayOfYear", new Class[0]), this.applySqlFunction("DAYOFYEAR"));
            this.javaMethods.put(LocalDate.class.getDeclaredMethod("getMonthValue", new Class[0]), this.applySqlFunction("MONTH"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getMonthValue", new Class[0]), this.applySqlFunction("MONTH"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getMonthValue", new Class[0]), this.applySqlFunction("MONTH"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getMonthValue", new Class[0]), this.applySqlFunction("MONTH"));
            this.javaMethods.put(LocalDate.class.getDeclaredMethod("getYear", new Class[0]), this.applySqlFunction("YEAR"));
            this.javaMethods.put(LocalDateTime.class.getDeclaredMethod("getYear", new Class[0]), this.applySqlFunction("YEAR"));
            this.javaMethods.put(OffsetDateTime.class.getDeclaredMethod("getYear", new Class[0]), this.applySqlFunction("YEAR"));
            this.javaMethods.put(ZonedDateTime.class.getDeclaredMethod("getYear", new Class[0]), this.applySqlFunction("YEAR"));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private static String toSqlOperator(int expressionType) {
        switch (expressionType) {
            case 10: {
                return "=";
            }
            case 2: {
                return "AND";
            }
            case 32: {
                return "OR";
            }
            case 15: {
                return " IS NULL";
            }
            case 16: {
                return " IS NOT NULL";
            }
            case 8: {
                return "";
            }
        }
        return ExpressionType.toString(expressionType);
    }

    @Override
    public StringBuilder visit(BinaryExpression e) {
        boolean quote;
        if (e.getSecond() instanceof ParameterExpression && !this.arguments.top().isEmpty() && this.arguments.top().get(((ParameterExpression)e.getSecond()).getIndex()).getValue() == null) {
            this.arguments.pop();
            return Expression.unary(e.getExpressionType() == 10 ? 15 : 16, Boolean.TYPE, e.getFirst()).accept(this);
        }
        boolean bl = quote = e != this.body && e.getExpressionType() == 32;
        if (quote) {
            this.sb.append('(');
        }
        e.getFirst().accept(this);
        this.sb.append(' ').append(SqlVisitor.toSqlOperator(e.getExpressionType())).append(' ');
        e.getSecond().accept(this);
        if (quote) {
            this.sb.append(')');
        }
        return this.sb;
    }

    @Override
    public StringBuilder visit(ConstantExpression e) {
        if (e.getValue() == null) {
            return this.sb.append("NULL");
        }
        if (e.getValue() instanceof LambdaExpression) {
            return ((LambdaExpression)e.getValue()).getBody().accept(this);
        }
        if (e.getValue() instanceof String || e.getValue() instanceof Temporal) {
            return this.sb.append("'").append(this.escapeString(e.getValue().toString())).append("'");
        }
        return this.sb.append(e.getValue());
    }

    @Override
    public StringBuilder visit(InvocationExpression e) {
        String sqlFunctionName;
        InvocableExpression target = e.getTarget();
        if (target instanceof LambdaExpression) {
            List list = e.getArguments().stream().filter(x -> x instanceof ConstantExpression).map(ConstantExpression.class::cast).collect(Collectors.toList());
            if (!list.isEmpty()) {
                this.arguments.push(list);
            }
        }
        if (target instanceof MemberExpression && (sqlFunctionName = sqlFunctionMethods.get(((MemberExpression)e.getTarget()).getMember())) != null) {
            this.sb.append(sqlFunctionName).append('(');
            e.getArguments().get(0).accept(this);
            this.sb.append(')');
            return this.sb;
        }
        if (e.getTarget().getExpressionType() == 23 && !e.getArguments().isEmpty()) {
            this.javaMethodParameter = e.getArguments().get(0);
        }
        return e.getTarget().accept(this);
    }

    @Override
    public StringBuilder visit(LambdaExpression e) {
        if (this.body == null && !(e.getBody() instanceof InvocationExpression) || e.getBody() instanceof InvocationExpression && !(((InvocationExpression)e.getBody()).getTarget() instanceof LambdaExpression)) {
            this.body = e.getBody();
        }
        return e.getBody().accept(this);
    }

    @Override
    public StringBuilder visit(DelegateExpression e) {
        return e.getDelegate().accept(this);
    }

    @Override
    public StringBuilder visit(MemberExpression e) {
        if (operatorMethods.containsKey(e.getMember())) {
            return Expression.binary(operatorMethods.get(e.getMember()), e.getInstance(), this.javaMethodParameter).accept(this);
        }
        TriFunction<Expression, Expression, Boolean, StringBuilder> javaMethodReplacer = this.javaMethods.get(e.getMember());
        if (javaMethodReplacer != null) {
            return this.sb.append((CharSequence)javaMethodReplacer.apply(e.getInstance(), this.javaMethodParameter, false));
        }
        char[] nameArray = e.getMember().getName().replaceAll("^(get)", "").toCharArray();
        nameArray[0] = Character.toLowerCase(nameArray[0]);
        String name = new String(nameArray);
        if (this.tableName == null) {
            return this.sb.append(name);
        }
        String escape = this.withBackticks ? "`" : "";
        return this.sb.append(escape).append(this.tableName).append(escape).append(".").append(escape).append(name).append(escape);
    }

    @Override
    public StringBuilder visit(ParameterExpression e) {
        this.arguments.top().get(e.getIndex()).accept(this);
        if (e.getIndex() == this.arguments.top().size() - 1) {
            int numberOfParameterUsages = this.countParameterUsages(e);
            if (this.arguments.size() > 1 || numberOfParameterUsages == 1 || numberOfParameterUsages == this.parameterConsumptionCount.merge(e.toString(), 1, Integer::sum)) {
                this.arguments.pop();
            }
        }
        return this.sb;
    }

    private int countParameterUsages(ParameterExpression e) {
        String identifier = e.toString();
        String expressionString = this.body.toString();
        return expressionString.split(identifier, -1).length - 1;
    }

    @Override
    public StringBuilder visit(UnaryExpression e) {
        if (e.getExpressionType() == 29) {
            InvocationExpression invocationExpression = (InvocationExpression)e.getFirst();
            MemberExpression memberExpression = (MemberExpression)invocationExpression.getTarget();
            if (operatorMethods.containsKey(memberExpression.getMember())) {
                return Expression.logicalNot(Expression.binary(operatorMethods.get(memberExpression.getMember()), memberExpression.getInstance(), invocationExpression.getArguments().get(0))).accept(this);
            }
            if (this.javaMethods.containsKey(memberExpression.getMember())) {
                return this.sb.append((CharSequence)this.javaMethods.get(memberExpression.getMember()).apply(memberExpression.getInstance(), invocationExpression.getArguments().get(0), true));
            }
            this.sb.append("!");
            return e.getFirst().accept(this);
        }
        e.getFirst().accept(this);
        return this.sb.append(SqlVisitor.toSqlOperator(e.getExpressionType()));
    }

    private StringBuilder stringStartsWith(Expression string, Expression argument, boolean isNegated) {
        return this.doStringOperation(string, argument, isNegated, valueBuilder -> valueBuilder.insert(valueBuilder.length() - 1, '%'));
    }

    private StringBuilder stringEndsWith(Expression string, Expression argument, boolean isNegated) {
        return this.doStringOperation(string, argument, isNegated, valueBuilder -> valueBuilder.insert(1, '%'));
    }

    private StringBuilder stringContains(Expression string, Expression argument, boolean isNegated) {
        return this.doStringOperation(string, argument, isNegated, valueBuilder -> valueBuilder.insert(1, '%').insert(valueBuilder.length() - 1, '%'));
    }

    private StringBuilder listContains(Expression list, Expression argument, boolean isNegated) {
        List l = (List)this.arguments.pop().get(((ParameterExpression)list).getIndex()).getValue();
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        l.forEach(x -> joiner.add(x.toString()));
        return argument.accept(new SqlVisitor(this.tableName, this.withBackticks, this.body, this.arguments)).append(isNegated ? " NOT" : "").append(" IN ").append(joiner);
    }

    private TriFunction<Expression, Expression, Boolean, StringBuilder> applySqlFunction(String field) {
        return (value, argument, isNegated) -> new StringBuilder().append(field).append("(").append((CharSequence)value.accept(new SqlVisitor(this.tableName, this.withBackticks, this.body, this.arguments))).append(')');
    }

    private StringBuilder doStringOperation(Expression member, Expression argument, boolean isNegated, Consumer<StringBuilder> modifier) {
        StringBuilder valueBuilder = argument.accept(new SqlVisitor(this.tableName, this.withBackticks, this.body, this.arguments));
        modifier.accept(valueBuilder);
        return member.accept(new SqlVisitor(this.tableName, this.withBackticks, this.body, this.arguments)).append(isNegated ? " NOT" : "").append(" LIKE ").append((CharSequence)valueBuilder);
    }

    private String escapeString(String input) {
        return input.replace("\\", "\\\\").replace("'", "\\'");
    }

    static {
        try {
            operatorMethods.put(String.class.getDeclaredMethod("equals", Object.class), 10);
            operatorMethods.put(Object.class.getDeclaredMethod("equals", Object.class), 10);
            operatorMethods.put(LocalTime.class.getDeclaredMethod("isAfter", LocalTime.class), 12);
            operatorMethods.put(LocalDate.class.getDeclaredMethod("isAfter", ChronoLocalDate.class), 12);
            operatorMethods.put(LocalDateTime.class.getDeclaredMethod("isAfter", ChronoLocalDateTime.class), 12);
            operatorMethods.put(LocalDate.class.getDeclaredMethod("isBefore", ChronoLocalDate.class), 20);
            operatorMethods.put(LocalTime.class.getDeclaredMethod("isBefore", LocalTime.class), 20);
            operatorMethods.put(LocalDateTime.class.getDeclaredMethod("isBefore", ChronoLocalDateTime.class), 20);
            sqlFunctionMethods.put(SqlFunctions.class.getDeclaredMethod("sum", Object.class), "SUM");
            sqlFunctionMethods.put(SqlFunctions.class.getDeclaredMethod("min", Object.class), "MIN");
            sqlFunctionMethods.put(SqlFunctions.class.getDeclaredMethod("max", Object.class), "MAX");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

