/*
 * Decompiled with CFR 0.152.
 */
package develop.framework.commons.components;

import develop.framework.commons.components.EntitySign;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public abstract class EntityRegistry<T extends EntitySign<K>, K>
implements Serializable {
    private static final long serialVersionUID = 8580818076321536793L;
    protected Map<K, T> entityMap = new LinkedHashMap<K, T>();

    public EntityRegistry() {
        EntitySign[] defaultEntities = this.defaultEntity();
        if (defaultEntities != null) {
            Arrays.stream(defaultEntities).forEach(entity -> this.entityMap.put(entity.key(), entity));
        }
    }

    protected abstract T[] defaultEntity();

    public void addCustomEntities(@NonNull T[] customEntities) {
        if (customEntities == null) {
            throw new NullPointerException("customEntities");
        }
        Arrays.stream(customEntities).forEach(entity -> this.entityMap.put(entity.key(), entity));
    }

    public Optional<T> extract(K key) {
        if (this.entityMap.containsKey(key)) {
            return Optional.of(this.entityMap.get(key));
        }
        return Optional.empty();
    }

    public T extractRequired(K key, RuntimeException customRuntimeException) {
        if (this.entityMap.containsKey(key)) {
            return (T)((EntitySign)this.entityMap.get(key));
        }
        throw customRuntimeException;
    }

    public T extractOrDefault(K key, T defaultValue) {
        if (this.entityMap.containsKey(key)) {
            return (T)((EntitySign)this.entityMap.get(key));
        }
        return defaultValue;
    }
}

