/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.cglib3_2_0.proxy.Callback;
import com.github.drinkjava2.cglib3_2_0.proxy.Enhancer;
import com.github.drinkjava2.cglib3_2_0.proxy.MethodInterceptor;
import com.github.drinkjava2.cglib3_2_0.proxy.MethodProxy;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.reflect.Method;

public class AliasProxyUtil {
    public static ThreadLocal<AliasItemInfo> aliasItemInfo = new ThreadLocal();

    public static <T> T createAliasProxy(Class<T> c) {
        return AliasProxyUtil.createAliasProxy(c, null);
    }

    public static <T> T createAliasProxy(Class<T> c, String alias) {
        TableModel t = TableModelUtils.entity2ReadOnlyModel(c);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(c);
        enhancer.setCallback((Callback)new ProxyBean(t, alias));
        return (T)enhancer.create();
    }

    public static SqlItem clean() {
        aliasItemInfo.remove();
        return new SqlItem("");
    }

    public static SqlItem alias(Object o) {
        try {
            AliasItemInfo a = aliasItemInfo.get();
            if (StrUtils.isEmpty((Object)a.colName)) {
                throw new SqlBoxException("Column name not found.");
            }
            if (StrUtils.isEmpty((Object)a.alias)) {
                SqlItem sqlItem = new SqlItem(a.colName);
                return sqlItem;
            }
            SqlItem sqlItem = new SqlItem(a.alias + "." + a.colName + " as " + a.alias + "_" + a.colName);
            return sqlItem;
        }
        finally {
            aliasItemInfo.remove();
        }
    }

    public static SqlItem c_alias(Object o) {
        try {
            AliasItemInfo a = aliasItemInfo.get();
            if (StrUtils.isEmpty((Object)a.colName)) {
                throw new SqlBoxException("Column name not found.");
            }
            if (StrUtils.isEmpty((Object)a.alias)) {
                SqlItem sqlItem = new SqlItem(", " + a.colName);
                return sqlItem;
            }
            SqlItem sqlItem = new SqlItem(", " + a.alias + "." + a.colName + " as " + a.alias + "_" + a.colName);
            return sqlItem;
        }
        finally {
            aliasItemInfo.remove();
        }
    }

    public static SqlItem col(Object o) {
        try {
            AliasItemInfo a = aliasItemInfo.get();
            if (StrUtils.isEmpty((Object)a.colName)) {
                throw new SqlBoxException("Column name not found.");
            }
            if (StrUtils.isEmpty((Object)a.alias)) {
                SqlItem sqlItem = new SqlItem(a.colName);
                return sqlItem;
            }
            SqlItem sqlItem = new SqlItem(a.alias + "." + a.colName);
            return sqlItem;
        }
        finally {
            aliasItemInfo.remove();
        }
    }

    public static SqlItem table(Object o) {
        try {
            o.toString();
            AliasItemInfo a = aliasItemInfo.get();
            if (StrUtils.isEmpty((Object)a.alias)) {
                SqlItem sqlItem = new SqlItem(a.tableName);
                return sqlItem;
            }
            SqlItem sqlItem = new SqlItem(a.tableName + " " + a.alias);
            return sqlItem;
        }
        finally {
            aliasItemInfo.remove();
        }
    }

    public static SqlItem TABLE(Object o) {
        return AliasProxyUtil.table(o);
    }

    static class ProxyBean
    implements MethodInterceptor {
        private TableModel tableModel;
        private String alias;

        public ProxyBean(TableModel tableModel, String alias) {
            this.tableModel = tableModel;
            this.alias = alias;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy cgLibMethodProxy) throws Throwable {
            aliasItemInfo.remove();
            if (method != null && this.tableModel != null) {
                String methodNm = method.getName();
                String fieldName = methodNm.startsWith("get") ? methodNm.substring(3) : methodNm.substring(2);
                String columnName = null;
                for (ColumnModel col : this.tableModel.getColumns()) {
                    if (!col.getEntityField().equalsIgnoreCase(fieldName)) continue;
                    columnName = col.getColumnName();
                }
                aliasItemInfo.set(new AliasItemInfo(this.tableModel.getTableName(), this.alias, columnName));
            }
            return null;
        }
    }

    static class AliasItemInfo {
        public String tableName = null;
        public String alias = null;
        public String colName = null;

        public AliasItemInfo(String tableName, String alias, String colName) {
            this.tableName = tableName;
            this.alias = alias;
            this.colName = colName;
        }
    }
}

