/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.error.EtherScanParseException;
import io.goodforgod.api.etherscan.error.EtherScanRateLimitException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.response.StringResponseTO;
import java.net.URI;
import java.nio.charset.StandardCharsets;

abstract class BasicProvider {
    private static final String MAX_RATE_LIMIT_REACHED = "Max rate limit reached";
    static final int MAX_END_BLOCK = Integer.MAX_VALUE;
    static final int MIN_START_BLOCK = 0;
    static final String ACT_PREFIX = "&action=";
    private final String module;
    private final String baseUrl;
    private final EthHttpClient executor;
    private final RequestQueueManager queue;
    private final Converter converter;

    BasicProvider(RequestQueueManager requestQueueManager, String module, String baseUrl, EthHttpClient ethHttpClient, Converter converter) {
        this.queue = requestQueueManager;
        this.module = "&module=" + module;
        this.baseUrl = baseUrl;
        this.executor = ethHttpClient;
        this.converter = converter;
    }

    <T> T convert(byte[] json, Class<T> tClass) {
        try {
            T t = this.converter.fromJson(json, tClass);
            if (t instanceof StringResponseTO && ((StringResponseTO)t).getResult().startsWith(MAX_RATE_LIMIT_REACHED)) {
                throw new EtherScanRateLimitException(((StringResponseTO)t).getResult());
            }
            return t;
        }
        catch (Exception e) {
            StringResponseTO response = this.converter.fromJson(json, StringResponseTO.class);
            if (response.getResult() != null && response.getStatus() == 0) {
                if (response.getResult().startsWith(MAX_RATE_LIMIT_REACHED)) {
                    throw new EtherScanRateLimitException(response.getResult());
                }
                throw new EtherScanResponseException(response);
            }
            String jsonAsString = new String(json, StandardCharsets.UTF_8);
            throw new EtherScanParseException(e.getMessage() + ", for response: " + jsonAsString, e.getCause(), jsonAsString);
        }
    }

    byte[] getRequest(String urlParameters) {
        this.queue.takeTurn();
        URI uri = URI.create(this.baseUrl + this.module + urlParameters);
        return this.executor.get(uri);
    }

    byte[] postRequest(String urlParameters, String dataToPost) {
        this.queue.takeTurn();
        URI uri = URI.create(this.baseUrl + this.module + urlParameters);
        return this.executor.post(uri, dataToPost.getBytes(StandardCharsets.UTF_8));
    }

    <T> T getRequest(String urlParameters, Class<T> tClass) {
        return this.convert(this.getRequest(urlParameters), tClass);
    }

    <T> T postRequest(String urlParameters, String dataToPost, Class<T> tClass) {
        return this.convert(this.postRequest(urlParameters, dataToPost), tClass);
    }
}

