/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.util;

import io.goodforgod.api.etherscan.error.EtherScanInvalidAddressException;
import io.goodforgod.api.etherscan.error.EtherScanInvalidTxHashException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.model.response.BaseResponseTO;
import io.goodforgod.api.etherscan.model.response.BlockParam;
import io.goodforgod.api.etherscan.model.response.StringResponseTO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class BasicUtils {
    private static final int MAX_END_BLOCK = Integer.MAX_VALUE;
    private static final int MIN_START_BLOCK = 0;
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("0x[a-zA-Z0-9]{40}");
    private static final Pattern TXHASH_PATTERN = Pattern.compile("0x[a-zA-Z0-9]{64}");
    private static final Pattern HEX_PATTERN = Pattern.compile("[a-zA-Z0-9]+");

    private BasicUtils() {
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isBlank(String value) {
        return BasicUtils.isEmpty(value) || value.trim().isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static BlockParam compensateBlocks(long startBlock, long endBlock) {
        long startCompensated = BasicUtils.compensateMinBlock(startBlock);
        long endCompensated = BasicUtils.compensateMaxBlock(endBlock);
        long startFinal = Math.min(startCompensated, endCompensated);
        long endFinal = Math.max(startCompensated, endCompensated);
        return new BlockParam(startFinal, endFinal);
    }

    public static long compensateMinBlock(long blockNumber) {
        return blockNumber < 0L ? 0L : blockNumber;
    }

    public static long compensateMaxBlock(long blockNumber) {
        return blockNumber > Integer.MAX_VALUE ? Integer.MAX_VALUE : blockNumber;
    }

    public static boolean isNotAddress(String value) {
        return BasicUtils.isEmpty(value) || !ADDRESS_PATTERN.matcher(value).matches();
    }

    public static boolean isNotTxHash(String value) {
        return BasicUtils.isEmpty(value) || !TXHASH_PATTERN.matcher(value).find();
    }

    public static boolean isNotHex(String value) {
        return BasicUtils.isEmpty(value) || !HEX_PATTERN.matcher(value).matches();
    }

    public static BigInteger parseHex(String hex) {
        try {
            if (BasicUtils.isEmpty(hex)) {
                return BigInteger.valueOf(0L);
            }
            String formatted = hex.length() > 2 && hex.charAt(0) == '0' && hex.charAt(1) == 'x' ? hex.substring(2) : hex;
            return new BigInteger(formatted, 16);
        }
        catch (NumberFormatException e) {
            return BigInteger.valueOf(-1L);
        }
    }

    public static void validateAddress(String address) {
        if (BasicUtils.isNotAddress(address)) {
            throw new EtherScanInvalidAddressException("Address [" + address + "] is not Ethereum based.");
        }
    }

    public static void validateTxHash(String txhash) {
        if (BasicUtils.isNotTxHash(txhash)) {
            throw new EtherScanInvalidTxHashException("TxHash [" + txhash + "] is not Ethereum based.");
        }
    }

    public static <T extends BaseResponseTO> void validateTxResponse(T response) {
        if (response == null) {
            StringResponseTO emptyResponse = StringResponseTO.builder().withStatus("0").withMessage("EtherScan responded with null value").build();
            throw new EtherScanResponseException(emptyResponse, "EtherScan responded with null value");
        }
        if (response.getStatus() != 1) {
            if (response.getMessage() == null) {
                throw new EtherScanResponseException(response, "Unexpected Etherscan exception, no information from server about error, code " + response.getStatus());
            }
            if (!response.getMessage().startsWith("No tra") && !response.getMessage().startsWith("No rec")) {
                throw new EtherScanResponseException(response);
            }
        }
    }

    public static void validateAddresses(List<String> addresses) {
        for (String address : addresses) {
            if (!BasicUtils.isNotAddress(address)) continue;
            throw new EtherScanInvalidAddressException("Address [" + address + "] is not Ethereum based.");
        }
    }

    @NotNull
    public static List<List<String>> partition(List<String> list, int pairSize) {
        if (BasicUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<List<String>> partitioned = new ArrayList<List<String>>();
        Iterator<String> iterator = list.iterator();
        int counter = 0;
        ArrayList<String> temp = new ArrayList<String>();
        while (iterator.hasNext()) {
            temp.add(iterator.next());
            if (++counter <= pairSize) continue;
            partitioned.add(temp);
            temp = new ArrayList();
            counter = 0;
        }
        if (!temp.isEmpty()) {
            partitioned.add(temp);
        }
        return partitioned;
    }
}

