/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.BigDecimalEncoderDecoder;
import com.github.jasync.sql.db.column.ColumnDecoder;
import com.github.jasync.sql.db.column.ColumnDecoderRegistry;
import com.github.jasync.sql.db.column.DateEncoderDecoder;
import com.github.jasync.sql.db.column.DoubleEncoderDecoder;
import com.github.jasync.sql.db.column.FloatEncoderDecoder;
import com.github.jasync.sql.db.column.InetAddressEncoderDecoder;
import com.github.jasync.sql.db.column.IntegerEncoderDecoder;
import com.github.jasync.sql.db.column.LongEncoderDecoder;
import com.github.jasync.sql.db.column.ShortEncoderDecoder;
import com.github.jasync.sql.db.column.StringEncoderDecoder;
import com.github.jasync.sql.db.column.TimeEncoderDecoder;
import com.github.jasync.sql.db.column.TimeWithTimezoneEncoderDecoder;
import com.github.jasync.sql.db.column.UUIDEncoderDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.postgresql.column.ArrayDecoder;
import com.github.jasync.sql.db.postgresql.column.BooleanEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.ByteArrayEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.CharEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLIntervalEncoderDecoder;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLTimestampEncoderDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry;", "Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "bigDecimalArrayDecoder", "Lcom/github/jasync/sql/db/postgresql/column/ArrayDecoder;", "booleanArrayDecoder", "charArrayDecoder", "getCharset", "()Ljava/nio/charset/Charset;", "dateArrayDecoder", "doubleArrayDecoder", "floatArrayDecoder", "inetAddressArrayDecoder", "integerArrayDecoder", "intervalArrayDecoder", "longArrayDecoder", "shortArrayDecoder", "stringArrayDecoder", "timeArrayDecoder", "timeWithTimestampArrayDecoder", "timestampArrayDecoder", "timestampWithTimezoneArrayDecoder", "uuidArrayDecoder", "decode", "", "kind", "Lcom/github/jasync/sql/db/general/ColumnData;", "value", "Lio/netty/buffer/ByteBuf;", "decoderFor", "Lcom/github/jasync/sql/db/column/ColumnDecoder;", "", "Companion", "jasync-postgresql"})
public final class PostgreSQLColumnDecoderRegistry
implements ColumnDecoderRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset charset;
    @NotNull
    private final ArrayDecoder stringArrayDecoder;
    @NotNull
    private final ArrayDecoder booleanArrayDecoder;
    @NotNull
    private final ArrayDecoder charArrayDecoder;
    @NotNull
    private final ArrayDecoder longArrayDecoder;
    @NotNull
    private final ArrayDecoder shortArrayDecoder;
    @NotNull
    private final ArrayDecoder integerArrayDecoder;
    @NotNull
    private final ArrayDecoder bigDecimalArrayDecoder;
    @NotNull
    private final ArrayDecoder floatArrayDecoder;
    @NotNull
    private final ArrayDecoder doubleArrayDecoder;
    @NotNull
    private final ArrayDecoder timestampArrayDecoder;
    @NotNull
    private final ArrayDecoder timestampWithTimezoneArrayDecoder;
    @NotNull
    private final ArrayDecoder dateArrayDecoder;
    @NotNull
    private final ArrayDecoder timeArrayDecoder;
    @NotNull
    private final ArrayDecoder timeWithTimestampArrayDecoder;
    @NotNull
    private final ArrayDecoder intervalArrayDecoder;
    @NotNull
    private final ArrayDecoder uuidArrayDecoder;
    @NotNull
    private final ArrayDecoder inetAddressArrayDecoder;
    @NotNull
    private static final PostgreSQLColumnDecoderRegistry Instance = new PostgreSQLColumnDecoderRegistry(null, 1, null);

    public PostgreSQLColumnDecoderRegistry(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
        this.stringArrayDecoder = new ArrayDecoder((ColumnDecoder)StringEncoderDecoder.INSTANCE);
        this.booleanArrayDecoder = new ArrayDecoder((ColumnDecoder)BooleanEncoderDecoder.INSTANCE);
        this.charArrayDecoder = new ArrayDecoder((ColumnDecoder)CharEncoderDecoder.INSTANCE);
        this.longArrayDecoder = new ArrayDecoder((ColumnDecoder)LongEncoderDecoder.INSTANCE);
        this.shortArrayDecoder = new ArrayDecoder((ColumnDecoder)ShortEncoderDecoder.INSTANCE);
        this.integerArrayDecoder = new ArrayDecoder((ColumnDecoder)IntegerEncoderDecoder.INSTANCE);
        this.bigDecimalArrayDecoder = new ArrayDecoder((ColumnDecoder)BigDecimalEncoderDecoder.INSTANCE);
        this.floatArrayDecoder = new ArrayDecoder((ColumnDecoder)FloatEncoderDecoder.INSTANCE);
        this.doubleArrayDecoder = new ArrayDecoder((ColumnDecoder)DoubleEncoderDecoder.INSTANCE);
        this.timestampArrayDecoder = new ArrayDecoder((ColumnDecoder)PostgreSQLTimestampEncoderDecoder.INSTANCE);
        this.timestampWithTimezoneArrayDecoder = new ArrayDecoder((ColumnDecoder)PostgreSQLTimestampEncoderDecoder.INSTANCE);
        this.dateArrayDecoder = new ArrayDecoder((ColumnDecoder)DateEncoderDecoder.INSTANCE);
        this.timeArrayDecoder = new ArrayDecoder((ColumnDecoder)TimeEncoderDecoder.Companion.getInstance());
        this.timeWithTimestampArrayDecoder = new ArrayDecoder((ColumnDecoder)TimeWithTimezoneEncoderDecoder.INSTANCE);
        this.intervalArrayDecoder = new ArrayDecoder((ColumnDecoder)PostgreSQLIntervalEncoderDecoder.INSTANCE);
        this.uuidArrayDecoder = new ArrayDecoder((ColumnDecoder)UUIDEncoderDecoder.INSTANCE);
        this.inetAddressArrayDecoder = new ArrayDecoder((ColumnDecoder)InetAddressEncoderDecoder.INSTANCE);
    }

    public /* synthetic */ PostgreSQLColumnDecoderRegistry(Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Charset charset2 = CharsetUtil.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        this(charset);
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @NotNull
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Object object = this.decoderFor(kind.dataType()).decode(kind, value, charset);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private final ColumnDecoder decoderFor(int kind) {
        ColumnDecoder columnDecoder;
        switch (kind) {
            case 16: {
                columnDecoder = (ColumnDecoder)BooleanEncoderDecoder.INSTANCE;
                break;
            }
            case 1000: {
                columnDecoder = this.booleanArrayDecoder;
                break;
            }
            case 18: {
                columnDecoder = (ColumnDecoder)CharEncoderDecoder.INSTANCE;
                break;
            }
            case 1002: {
                columnDecoder = this.charArrayDecoder;
                break;
            }
            case 20: {
                columnDecoder = (ColumnDecoder)LongEncoderDecoder.INSTANCE;
                break;
            }
            case 1016: {
                columnDecoder = this.longArrayDecoder;
                break;
            }
            case 21: {
                columnDecoder = (ColumnDecoder)ShortEncoderDecoder.INSTANCE;
                break;
            }
            case 1005: {
                columnDecoder = this.shortArrayDecoder;
                break;
            }
            case 23: {
                columnDecoder = (ColumnDecoder)IntegerEncoderDecoder.INSTANCE;
                break;
            }
            case 1007: {
                columnDecoder = this.integerArrayDecoder;
                break;
            }
            case 26: {
                columnDecoder = (ColumnDecoder)LongEncoderDecoder.INSTANCE;
                break;
            }
            case 1028: {
                columnDecoder = this.longArrayDecoder;
                break;
            }
            case 1700: {
                columnDecoder = (ColumnDecoder)BigDecimalEncoderDecoder.INSTANCE;
                break;
            }
            case 1231: {
                columnDecoder = this.bigDecimalArrayDecoder;
                break;
            }
            case 700: {
                columnDecoder = (ColumnDecoder)FloatEncoderDecoder.INSTANCE;
                break;
            }
            case 1021: {
                columnDecoder = this.floatArrayDecoder;
                break;
            }
            case 701: {
                columnDecoder = (ColumnDecoder)DoubleEncoderDecoder.INSTANCE;
                break;
            }
            case 1022: {
                columnDecoder = this.doubleArrayDecoder;
                break;
            }
            case 25: {
                columnDecoder = (ColumnDecoder)StringEncoderDecoder.INSTANCE;
                break;
            }
            case 1009: {
                columnDecoder = this.stringArrayDecoder;
                break;
            }
            case 1043: {
                columnDecoder = (ColumnDecoder)StringEncoderDecoder.INSTANCE;
                break;
            }
            case 1015: {
                columnDecoder = this.stringArrayDecoder;
                break;
            }
            case 1042: {
                columnDecoder = (ColumnDecoder)StringEncoderDecoder.INSTANCE;
                break;
            }
            case 1014: {
                columnDecoder = this.stringArrayDecoder;
                break;
            }
            case 1114: {
                columnDecoder = (ColumnDecoder)PostgreSQLTimestampEncoderDecoder.INSTANCE;
                break;
            }
            case 1115: {
                columnDecoder = this.timestampArrayDecoder;
                break;
            }
            case 1184: {
                columnDecoder = (ColumnDecoder)PostgreSQLTimestampEncoderDecoder.INSTANCE;
                break;
            }
            case 1185: {
                columnDecoder = this.timestampWithTimezoneArrayDecoder;
                break;
            }
            case 1082: {
                columnDecoder = (ColumnDecoder)DateEncoderDecoder.INSTANCE;
                break;
            }
            case 1182: {
                columnDecoder = this.dateArrayDecoder;
                break;
            }
            case 1083: {
                columnDecoder = (ColumnDecoder)TimeEncoderDecoder.Companion.getInstance();
                break;
            }
            case 1183: {
                columnDecoder = this.timeArrayDecoder;
                break;
            }
            case 1266: {
                columnDecoder = (ColumnDecoder)TimeWithTimezoneEncoderDecoder.INSTANCE;
                break;
            }
            case 1270: {
                columnDecoder = this.timeWithTimestampArrayDecoder;
                break;
            }
            case 1186: {
                columnDecoder = (ColumnDecoder)PostgreSQLIntervalEncoderDecoder.INSTANCE;
                break;
            }
            case 1187: {
                columnDecoder = this.intervalArrayDecoder;
                break;
            }
            case 791: {
                columnDecoder = this.stringArrayDecoder;
                break;
            }
            case 1003: {
                columnDecoder = this.stringArrayDecoder;
                break;
            }
            case 2950: {
                columnDecoder = (ColumnDecoder)UUIDEncoderDecoder.INSTANCE;
                break;
            }
            case 2951: {
                columnDecoder = this.uuidArrayDecoder;
                break;
            }
            case 143: {
                columnDecoder = this.stringArrayDecoder;
                break;
            }
            case 17: {
                columnDecoder = (ColumnDecoder)ByteArrayEncoderDecoder.INSTANCE;
                break;
            }
            case 869: {
                columnDecoder = (ColumnDecoder)InetAddressEncoderDecoder.INSTANCE;
                break;
            }
            case 1041: {
                columnDecoder = this.inetAddressArrayDecoder;
                break;
            }
            default: {
                columnDecoder = (ColumnDecoder)StringEncoderDecoder.INSTANCE;
            }
        }
        return columnDecoder;
    }

    public PostgreSQLColumnDecoderRegistry() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry$Companion;", "", "()V", "Instance", "Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry;", "getInstance", "()Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLColumnDecoderRegistry;", "jasync-postgresql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PostgreSQLColumnDecoderRegistry getInstance() {
            return Instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

