/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.codec;

import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.postgresql.codec.MessageDecoder;
import com.github.jasync.sql.db.postgresql.codec.MessageEncoder;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionHandlerKt;
import com.github.jasync.sql.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.DataRowMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ErrorMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.NotificationResponse;
import com.github.jasync.sql.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ProcessData;
import com.github.jasync.sql.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.SSLResponseMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.CloseMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.SSLRequestMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.StartupMessage;
import com.github.jasync.sql.db.util.ChannelFutureTransformerKt;
import com.github.jasync.sql.db.util.ExecutorServiceUtils;
import com.github.jasync.sql.db.util.Failure;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.NettyUtils;
import com.github.jasync.sql.db.util.Success;
import com.github.jasync.sql.db.util.Try;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.CodecException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLEngine;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017H\u0016J\u0010\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017H\u0016J\u001a\u0010)\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010*\u001a\u00020\u0002H\u0014J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015J\u0018\u0010-\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017H\u0016J\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020&2\u0006\u0010*\u001a\u000204R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010!\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010$0#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "encoderRegistry", "Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "connectionDelegate", "Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;", "group", "Lio/netty/channel/EventLoopGroup;", "executionContext", "Ljava/util/concurrent/Executor;", "(Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;Lio/netty/channel/EventLoopGroup;Ljava/util/concurrent/Executor;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "getConfiguration", "()Lcom/github/jasync/sql/db/Configuration;", "getConnectionDelegate", "()Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;", "connectionFuture", "Ljava/util/concurrent/CompletableFuture;", "currentContext", "Lio/netty/channel/ChannelHandlerContext;", "disconnectionPromise", "getEncoderRegistry", "()Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "getExecutionContext", "()Ljava/util/concurrent/Executor;", "getGroup", "()Lio/netty/channel/EventLoopGroup;", "processData", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ProcessData;", "properties", "", "Lkotlin/Pair;", "", "channelActive", "", "ctx", "channelInactive", "channelRead0", "message", "connect", "disconnect", "exceptionCaught", "cause", "", "handlerAdded", "isConnected", "", "write", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "jasync-postgresql"})
@SourceDebugExtension(value={"SMAP\nPostgreSQLConnectionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostgreSQLConnectionHandler.kt\ncom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FutureUtils.kt\ncom/github/jasync/sql/db/util/FutureUtilsKt\n*L\n1#1,254:1\n766#2:255\n857#2,2:256\n92#3,6:258\n*S KotlinDebug\n*F\n+ 1 PostgreSQLConnectionHandler.kt\ncom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionHandler\n*L\n61#1:255\n61#1:256,2\n103#1:258,6\n*E\n"})
public final class PostgreSQLConnectionHandler
extends SimpleChannelInboundHandler<Object> {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final ColumnEncoderRegistry encoderRegistry;
    @NotNull
    private final PostgreSQLConnectionDelegate connectionDelegate;
    @NotNull
    private final EventLoopGroup group;
    @NotNull
    private final Executor executionContext;
    @NotNull
    private final List<Pair<String, String>> properties;
    @NotNull
    private final Bootstrap bootstrap;
    @NotNull
    private final CompletableFuture<PostgreSQLConnectionHandler> connectionFuture;
    @NotNull
    private final CompletableFuture<PostgreSQLConnectionHandler> disconnectionPromise;
    @Nullable
    private ProcessData processData;
    @Nullable
    private ChannelHandlerContext currentContext;

    /*
     * WARNING - void declaration
     */
    public PostgreSQLConnectionHandler(@NotNull Configuration configuration, @NotNull ColumnEncoderRegistry encoderRegistry, @NotNull PostgreSQLConnectionDelegate connectionDelegate, @NotNull EventLoopGroup group, @NotNull Executor executionContext) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)encoderRegistry, (String)"encoderRegistry");
        Intrinsics.checkNotNullParameter((Object)connectionDelegate, (String)"connectionDelegate");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.connectionDelegate = connectionDelegate;
        this.group = group;
        this.executionContext = executionContext;
        Object object = new Pair[]{TuplesKt.to((Object)"user", (Object)this.configuration.getUsername()), TuplesKt.to((Object)"database", (Object)this.configuration.getDatabase()), TuplesKt.to((Object)"client_encoding", (Object)this.configuration.getCharset().name()), TuplesKt.to((Object)"DateStyle", (Object)"ISO"), TuplesKt.to((Object)"extra_float_digits", (Object)"2"), TuplesKt.to((Object)"search_path", (Object)this.configuration.getCurrentSchema())};
        object = CollectionsKt.listOf((Object[])object);
        PostgreSQLConnectionHandler postgreSQLConnectionHandler = this;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        postgreSQLConnectionHandler.properties = (List)destination$iv$iv;
        this.bootstrap = new Bootstrap();
        this.connectionFuture = new CompletableFuture();
        this.disconnectionPromise = new CompletableFuture();
    }

    public /* synthetic */ PostgreSQLConnectionHandler(Configuration configuration, ColumnEncoderRegistry columnEncoderRegistry, PostgreSQLConnectionDelegate postgreSQLConnectionDelegate, EventLoopGroup eventLoopGroup, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            executor = ExecutorServiceUtils.INSTANCE.getCommonPool();
        }
        this(configuration, columnEncoderRegistry, postgreSQLConnectionDelegate, eventLoopGroup, executor);
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final ColumnEncoderRegistry getEncoderRegistry() {
        return this.encoderRegistry;
    }

    @NotNull
    public final PostgreSQLConnectionDelegate getConnectionDelegate() {
        return this.connectionDelegate;
    }

    @NotNull
    public final EventLoopGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final Executor getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public final CompletableFuture<PostgreSQLConnectionHandler> connect() {
        NettyUtils.SocketChannelClassAndSocketAddress socketChannelAddress = NettyUtils.INSTANCE.getSocketChannelClassAndSocketAddress(this.group, this.configuration);
        this.bootstrap.group(this.group);
        this.bootstrap.channel(socketChannelAddress.getSocketChannelClass());
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(this){
            final /* synthetic */ PostgreSQLConnectionHandler this$0;
            {
                this.this$0 = $receiver;
            }

            protected void initChannel(@NotNull Channel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new MessageDecoder(this.this$0.getConfiguration().getSsl().getMode() != SSLConfiguration.Mode.Disable, this.this$0.getConfiguration().getCharset(), this.this$0.getConfiguration().getMaximumMessageSize()), new MessageEncoder(this.this$0.getConfiguration().getCharset(), this.this$0.getEncoderRegistry()), this.this$0};
                ch.pipeline().addLast(channelHandlerArray);
            }
        });
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.configuration.getAllocator());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectionTimeout());
        ChannelFuture channelFuture = this.bootstrap.connect(socketChannelAddress.getSocketAddress());
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"this.bootstrap.connect(s\u2026nelAddress.socketAddress)");
        ChannelFutureTransformerKt.onFailure((ChannelFuture)channelFuture, (Executor)this.executionContext, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ PostgreSQLConnectionHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnectionHandler.access$getConnectionFuture$p(this.this$0), (Throwable)e);
            }
        }));
        return this.connectionFuture;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<PostgreSQLConnectionHandler> disconnect() {
        if (this.isConnected()) {
            void $this$onCompleteAsync$iv;
            ChannelHandlerContext channelHandlerContext = this.currentContext;
            Intrinsics.checkNotNull((Object)channelHandlerContext);
            ChannelFuture channelFuture = channelHandlerContext.channel().writeAndFlush((Object)CloseMessage.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"this.currentContext!!.ch\u2026iteAndFlush(CloseMessage)");
            CompletableFuture completableFuture = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)channelFuture);
            Executor executor$iv = this.executionContext;
            boolean $i$f$onCompleteAsync = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$onCompleteAsync$iv.whenCompleteAsync(new BiConsumer(this){
                final /* synthetic */ PostgreSQLConnectionHandler this$0;
                {
                    this.this$0 = postgreSQLConnectionHandler;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final void accept(Object a, Throwable t) {
                    Throwable throwable = t;
                    Try ty1 = throwable != null ? Try.Companion.raise(throwable) : Try.Companion.just(a);
                    boolean bl = false;
                    Try try_ = ty1;
                    if (try_ instanceof Success) {
                        void $this$onCompleteAsync$iv;
                        ChannelFuture channelFuture = ((ChannelFuture)ty1.get()).channel().close();
                        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"ty1.get().channel().close()");
                        CompletableFuture completableFuture = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)channelFuture);
                        Executor executor$iv = this.this$0.getExecutionContext();
                        boolean $i$f$onCompleteAsync = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$onCompleteAsync$iv.whenCompleteAsync(new BiConsumer(this.this$0){
                            final /* synthetic */ PostgreSQLConnectionHandler this$0;
                            {
                                this.this$0 = postgreSQLConnectionHandler;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void accept(Object a, Throwable t) {
                                Throwable throwable = t;
                                Try ty2 = throwable != null ? Try.Companion.raise(throwable) : Try.Companion.just(a);
                                boolean bl = false;
                                Try try_ = ty2;
                                if (try_ instanceof Success) {
                                    FutureUtilsKt.success((CompletableFuture)PostgreSQLConnectionHandler.access$getDisconnectionPromise$p(this.this$0), (Object)((Object)this.this$0));
                                } else if (try_ instanceof Failure) {
                                    FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnectionHandler.access$getDisconnectionPromise$p(this.this$0), (Throwable)((Failure)ty2).getException());
                                }
                            }
                        }, executor$iv), (String)"crossinline onCompleteFu\u2026},\n        executor\n    )");
                    } else if (try_ instanceof Failure) {
                        ChannelHandlerContext channelHandlerContext = PostgreSQLConnectionHandler.access$getCurrentContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)channelHandlerContext);
                        channelHandlerContext.channel().close();
                        FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnectionHandler.access$getDisconnectionPromise$p(this.this$0), (Throwable)((Failure)ty1).getException());
                    }
                }
            }, executor$iv), (String)"crossinline onCompleteFu\u2026},\n        executor\n    )");
        }
        return this.disconnectionPromise;
    }

    public final boolean isConnected() {
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        return channelHandlerContext != null && (channelHandlerContext = channelHandlerContext.channel()) != null ? channelHandlerContext.isActive() : false;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.configuration.getSsl().getMode() == SSLConfiguration.Mode.Disable) {
            ctx.writeAndFlush((Object)new StartupMessage(this.properties));
        } else {
            ctx.writeAndFlush((Object)SSLRequestMessage.INSTANCE);
        }
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PostgreSQLConnectionHandlerKt.access$getLogger$p().trace((Function0)new Function0<Object>(message){
            final /* synthetic */ Object $message;
            {
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "got message " + this.$message;
            }
        });
        Object object = message;
        if (Intrinsics.areEqual((Object)object, (Object)new SSLResponseMessage(true))) {
            SslContext sslContext = NettyUtils.INSTANCE.createSslContext(this.configuration.getSsl());
            ChannelHandlerContext channelHandlerContext = ctx;
            Intrinsics.checkNotNull((Object)channelHandlerContext);
            SSLEngine sslEngine = sslContext.newEngine(channelHandlerContext.alloc(), this.configuration.getHost(), this.configuration.getPort());
            if (this.configuration.getSsl().getMode() == SSLConfiguration.Mode.VerifyFull) {
                Intrinsics.checkNotNullExpressionValue((Object)sslEngine, (String)"sslEngine");
                NettyUtils.INSTANCE.verifyHostIdentity(sslEngine);
            }
            SslHandler handler = new SslHandler(sslEngine);
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{handler};
            ctx.pipeline().addFirst(channelHandlerArray);
            handler.handshakeFuture().addListener(arg_0 -> PostgreSQLConnectionHandler.channelRead0$lambda$3(ctx, this, arg_0));
        } else if (Intrinsics.areEqual((Object)object, (Object)new SSLResponseMessage(false))) {
            if (this.configuration.getSsl().getMode().compareTo((Enum)SSLConfiguration.Mode.Require) < 0) {
                ChannelHandlerContext channelHandlerContext = ctx;
                Intrinsics.checkNotNull((Object)channelHandlerContext);
                channelHandlerContext.writeAndFlush((Object)new StartupMessage(this.properties));
            } else {
                this.connectionDelegate.onError(new IllegalArgumentException("SSL is not supported on server"));
            }
        } else if (object instanceof ServerMessage) {
            switch (((ServerMessage)message).getKind()) {
                case 75: {
                    this.processData = (ProcessData)message;
                    break;
                }
                case 50: {
                    break;
                }
                case 82: {
                    PostgreSQLConnectionHandlerKt.access$getLogger$p().debug("Authentication response received " + message);
                    this.connectionDelegate.onAuthenticationResponse((AuthenticationMessage)message);
                    break;
                }
                case 67: {
                    this.connectionDelegate.onCommandComplete((CommandCompleteMessage)message);
                    break;
                }
                case 51: {
                    this.connectionDelegate.onCloseComplete();
                    break;
                }
                case 68: {
                    this.connectionDelegate.onDataRow((DataRowMessage)message);
                    break;
                }
                case 69: {
                    this.connectionDelegate.onError((ErrorMessage)message);
                    break;
                }
                case 73: {
                    QueryMustNotBeNullOrEmptyException exception = new QueryMustNotBeNullOrEmptyException("");
                    this.connectionDelegate.onError((Throwable)((Object)exception));
                    break;
                }
                case 110: {
                    break;
                }
                case 78: {
                    PostgreSQLConnectionHandlerKt.access$getLogger$p().info("Received notice " + message);
                    break;
                }
                case 65: {
                    this.connectionDelegate.onNotificationResponse((NotificationResponse)message);
                    break;
                }
                case 83: {
                    this.connectionDelegate.onParameterStatus((ParameterStatusMessage)message);
                    break;
                }
                case 49: {
                    break;
                }
                case 90: {
                    this.connectionDelegate.onReadyForQuery();
                    break;
                }
                case 84: {
                    this.connectionDelegate.onRowDescription((RowDescriptionMessage)message);
                    break;
                }
                default: {
                    String string = "Handler not implemented for message %s";
                    Object[] objectArray = new Object[]{((ServerMessage)message).getKind()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                    IllegalStateException exception = new IllegalStateException(string2);
                    this.connectionDelegate.onError(exception);
                    break;
                }
            }
        } else {
            PostgreSQLConnectionHandlerKt.access$getLogger$p().error("Unknown message type - " + message);
            String string = "Unknown message type - %s";
            Object[] objectArray = new Object[]{message};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
            IllegalArgumentException exception = new IllegalArgumentException(string3);
            this.connectionDelegate.onError(exception);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (cause instanceof CodecException) {
            Throwable throwable = cause.getCause();
            Intrinsics.checkNotNull((Object)throwable);
            this.connectionDelegate.onError(throwable);
        } else {
            this.connectionDelegate.onError(cause);
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        PostgreSQLConnectionHandlerKt.access$getLogger$p().info("Connection disconnected - {}", (Object)ctx.channel().remoteAddress());
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.currentContext = ctx;
    }

    public final void write(@NotNull ClientMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        Intrinsics.checkNotNull((Object)channelHandlerContext);
        ChannelFuture channelFuture = channelHandlerContext.writeAndFlush((Object)message);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"this.currentContext!!.writeAndFlush(message)");
        ChannelFutureTransformerKt.onFailure((ChannelFuture)channelFuture, (Executor)this.executionContext, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ PostgreSQLConnectionHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getConnectionDelegate().onError(e);
            }
        }));
    }

    private static final void channelRead0$lambda$3(ChannelHandlerContext $ctx, PostgreSQLConnectionHandler this$0, Future future) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (future.isSuccess()) {
            $ctx.writeAndFlush((Object)new StartupMessage(this$0.properties));
        } else {
            PostgreSQLConnectionDelegate postgreSQLConnectionDelegate = this$0.connectionDelegate;
            Throwable throwable = future.cause();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"future.cause()");
            postgreSQLConnectionDelegate.onError(throwable);
        }
    }

    public static final /* synthetic */ CompletableFuture access$getConnectionFuture$p(PostgreSQLConnectionHandler $this) {
        return $this.connectionFuture;
    }

    public static final /* synthetic */ CompletableFuture access$getDisconnectionPromise$p(PostgreSQLConnectionHandler $this) {
        return $this.disconnectionPromise;
    }

    public static final /* synthetic */ ChannelHandlerContext access$getCurrentContext$p(PostgreSQLConnectionHandler $this) {
        return $this.currentContext;
    }
}

