/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.exceptions.DateEncoderNotAvailableException;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.jasync.sql.db.util.EncodingUtilsKt;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\tH\u0016J\u000e\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLTimestampEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "internalFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "internalFormatterWithoutSeconds", "optionalTimeZone", "decode", "", "kind", "Lcom/github/jasync/sql/db/general/ColumnData;", "value", "Lio/netty/buffer/ByteBuf;", "charset", "Ljava/nio/charset/Charset;", "", "encode", "formatter", "selectFormatter", "text", "supportsStringDecoding", "", "jasync-postgresql"})
@SourceDebugExtension(value={"SMAP\nPostgreSQLTimestampEncoderDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostgreSQLTimestampEncoderDecoder.kt\ncom/github/jasync/sql/db/postgresql/column/PostgreSQLTimestampEncoderDecoder\n+ 2 KotlinUtils.kt\ncom/github/jasync/sql/db/util/KotlinUtilsKt\n*L\n1#1,89:1\n6#2:90\n*S KotlinDebug\n*F\n+ 1 PostgreSQLTimestampEncoderDecoder.kt\ncom/github/jasync/sql/db/postgresql/column/PostgreSQLTimestampEncoderDecoder\n*L\n61#1:90\n*E\n"})
public final class PostgreSQLTimestampEncoderDecoder
implements ColumnEncoderDecoder {
    @NotNull
    public static final PostgreSQLTimestampEncoderDecoder INSTANCE = new PostgreSQLTimestampEncoderDecoder();
    private static final DateTimeFormatter optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("X").toFormatter();
    private static final DateTimeFormatter internalFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(EncodingUtilsKt.getMicrosecondsFormatter()).appendOptional(optionalTimeZone).toFormatter();
    private static final DateTimeFormatter internalFormatterWithoutSeconds = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(optionalTimeZone).toFormatter();

    private PostgreSQLTimestampEncoderDecoder() {
    }

    public final DateTimeFormatter formatter() {
        return internalFormatter;
    }

    @NotNull
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Comparable<ChronoLocalDateTime<?>> comparable;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        String text = new String(bytes, charset);
        PostgreSQLColumnData columnType = (PostgreSQLColumnData)kind;
        switch (columnType.getDataType()) {
            case 1114: 
            case 1115: {
                comparable = LocalDateTime.parse(text, this.selectFormatter(text));
                break;
            }
            case 1185: {
                comparable = OffsetDateTime.parse(text, this.selectFormatter(text));
                break;
            }
            case 1184: {
                if (columnType.getDataTypeModifier() > 0) {
                    comparable = OffsetDateTime.parse(text, internalFormatter);
                    break;
                }
                comparable = OffsetDateTime.parse(text, this.selectFormatter(text));
                break;
            }
            default: {
                String reason$iv = "should treat " + columnType.getDataType();
                boolean $i$f$XXX = false;
                throw new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"when (columnType.dataTyp\u2026ype.dataType}\")\n        }");
        return comparable;
    }

    private final DateTimeFormatter selectFormatter(String text) {
        DateTimeFormatter dateTimeFormatter;
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)".", (boolean)false, (int)2, null)) {
            DateTimeFormatter dateTimeFormatter2 = internalFormatter;
            dateTimeFormatter = dateTimeFormatter2;
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"{\n            internalFormatter\n        }");
        } else {
            DateTimeFormatter dateTimeFormatter3 = internalFormatterWithoutSeconds;
            dateTimeFormatter = dateTimeFormatter3;
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter3, (String)"{\n            internalFo\u2026rWithoutSeconds\n        }");
        }
        return dateTimeFormatter;
    }

    @NotNull
    public Object decode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new UnsupportedOperationException("this method should not have been called");
    }

    @NotNull
    public String encode(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            String string2 = ((Timestamp)value).toInstant().atOffset(ZoneOffset.UTC).format(this.formatter());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.toInstant().atOffs\u2026.format(this.formatter())");
        } else if (object instanceof Date) {
            String string3 = ((Date)value).toInstant().atOffset(ZoneOffset.UTC).format(this.formatter());
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value.toInstant().atOffs\u2026.format(this.formatter())");
        } else if (object instanceof Calendar) {
            String string4 = ((Calendar)value).toInstant().atOffset(ZoneOffset.UTC).format(this.formatter());
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"value.toInstant().atOffs\u2026.format(this.formatter())");
        } else if (object instanceof LocalDateTime) {
            String string5 = this.formatter().format((TemporalAccessor)value);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this.formatter().format(value)");
        } else if (object instanceof TemporalAccessor) {
            String string6 = this.formatter().format((TemporalAccessor)value);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this.formatter().format(value)");
        } else {
            throw new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    public boolean supportsStringDecoding() {
        return false;
    }
}

