/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.util;

import com.github.jasync.sql.db.postgresql.exceptions.InvalidArrayException;
import com.github.jasync.sql.db.postgresql.util.ArrayStreamingParserDelegate;
import com.github.jasync.sql.db.util.KotlinUtilsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\u00042\u000e\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lcom/github/jasync/sql/db/postgresql/util/ArrayStreamingParser;", "", "()V", "parse", "", "content", "", "delegate", "Lcom/github/jasync/sql/db/postgresql/util/ArrayStreamingParserDelegate;", "sendElementEvent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "quoted", "", "jasync-postgresql"})
public final class ArrayStreamingParser {
    @NotNull
    public static final ArrayStreamingParser INSTANCE = new ArrayStreamingParser();

    private ArrayStreamingParser() {
    }

    public final void parse(@NotNull String content, @NotNull ArrayStreamingParserDelegate delegate2) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        boolean escaping = false;
        boolean quoted = false;
        StringBuilder currentElement = null;
        int opens = 0;
        int closes = 0;
        for (int index = 0; index < KotlinUtilsKt.getSize((String)content); ++index) {
            char c = content.charAt(index);
            if (escaping) {
                StringBuilder stringBuilder = currentElement;
                Intrinsics.checkNotNull(stringBuilder);
                stringBuilder.append(c);
                escaping = false;
                continue;
            }
            if (c == '{' && !quoted) {
                delegate2.arrayStarted();
                ++opens;
                continue;
            }
            if (c == '}' && !quoted) {
                if (currentElement != null) {
                    this.sendElementEvent(currentElement, quoted, delegate2);
                    currentElement = null;
                }
                delegate2.arrayEnded();
                ++closes;
                continue;
            }
            if (c == '\"') {
                if (quoted) {
                    this.sendElementEvent(currentElement, quoted, delegate2);
                    currentElement = null;
                    quoted = false;
                    continue;
                }
                quoted = true;
                currentElement = new StringBuilder();
                continue;
            }
            if (c == ',' && !quoted) {
                if (currentElement != null) {
                    this.sendElementEvent(currentElement, quoted, delegate2);
                }
                currentElement = null;
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            if (currentElement == null) {
                currentElement = new StringBuilder();
            }
            currentElement.append(c);
        }
        if (opens != closes) {
            String string = "This array is unbalanced %s";
            Object[] objectArray = new Object[]{content};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            throw new InvalidArrayException(string2);
        }
    }

    public final void sendElementEvent(@Nullable StringBuilder builder, boolean quoted, @NotNull ArrayStreamingParserDelegate delegate2) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        String value = String.valueOf(builder);
        if (!quoted && StringsKt.equals((String)"NULL", (String)value, (boolean)true)) {
            delegate2.nullElementFound();
        } else {
            delegate2.elementFound(value);
        }
    }
}

